/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.analysis;

import java.util.ArrayList;
import java.util.List;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredState;

public class SyntacticProperties
implements StoredAutomatonManipulator {
    @Override
    public StoredAutomaton manipulate(StoredAutomaton aut) throws HOAConsumerException {
        aut.getStoredHeader().addProperties(SyntacticProperties.deduceProperties(aut));
        return aut;
    }

    public static List<String> deduceProperties(StoredAutomaton aut) {
        boolean has_one_state;
        ArrayList<String> deducedProperties = new ArrayList<String>();
        boolean state_labels = true;
        boolean trans_labels = true;
        boolean implicit_labels = true;
        boolean explicit_labels = true;
        boolean state_acc = true;
        boolean trans_acc = true;
        boolean univ_branch = false;
        boolean deterministic = true;
        boolean complete = false;
        boolean has_labels = false;
        boolean has_acceptance = false;
        boolean bl = has_one_state = aut.getNumberOfStates() > 0;
        if (aut.getStoredHeader().getStartStates().size() > 1) {
            deterministic = false;
        }
        for (List<Integer> start : aut.getStoredHeader().getStartStates()) {
            if (start.size() <= 1) continue;
            deterministic = false;
            univ_branch = true;
        }
        for (StoredState s : aut.getStoredStates()) {
            if (s.getLabelExpr() != null) {
                trans_labels = false;
                has_labels = true;
            }
            if (s.getAccSignature() != null) {
                trans_acc = false;
                has_acceptance = true;
            }
            if (aut.hasEdgesImplicit(s.getStateId())) {
                for (StoredEdgeImplicit storedEdgeImplicit : aut.getEdgesImplicit(s.getStateId())) {
                    has_labels = true;
                    state_labels = false;
                    explicit_labels = false;
                    if (storedEdgeImplicit.getAccSignature() != null) {
                        has_acceptance = true;
                        state_acc = false;
                    }
                    if (storedEdgeImplicit.getConjSuccessors().size() <= 1) continue;
                    univ_branch = true;
                }
                continue;
            }
            if (!aut.hasEdgesWithLabel(s.getStateId())) continue;
            implicit_labels = false;
            for (StoredEdgeWithLabel storedEdgeWithLabel : aut.getEdgesWithLabel(s.getStateId())) {
                if (storedEdgeWithLabel.getLabelExpr() != null) {
                    has_labels = true;
                    state_labels = false;
                    deterministic = false;
                    complete = false;
                }
                if (storedEdgeWithLabel.getAccSignature() != null) {
                    has_acceptance = true;
                    state_acc = false;
                }
                if (storedEdgeWithLabel.getConjSuccessors().size() <= 1) continue;
                univ_branch = true;
            }
        }
        if (has_one_state) {
            if (deterministic) {
                deducedProperties.add("deterministic");
            }
            if (univ_branch) {
                deducedProperties.add("univ-branch");
            } else {
                deducedProperties.add("no-univ-branch");
            }
            if (has_labels) {
                if (state_labels) {
                    deducedProperties.add("state-labels");
                }
                if (trans_labels) {
                    deducedProperties.add("trans-labels");
                }
                if (implicit_labels) {
                    deducedProperties.add("implicit-labels");
                }
                if (explicit_labels) {
                    deducedProperties.add("explicit-labels");
                }
                if (complete) {
                    deducedProperties.add("complete");
                }
            }
            if (has_acceptance) {
                if (state_acc) {
                    deducedProperties.add("state-acc");
                }
                if (trans_acc) {
                    deducedProperties.add("trans-acc");
                }
            }
        }
        return deducedProperties;
    }
}

