/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.map;

import de.tum.in.naturals.map.AbstractInt2IntEntrySet;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.AbstractInt2IntMap;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;

public class Nat2IntDenseArrayMap
extends AbstractInt2IntMap {
    private static final long serialVersionUID = 5185461790033343414L;
    private final int[] array;
    @Nullable
    private transient EntrySetView entriesView = null;
    @Nullable
    private transient KeySetView keySetView = null;
    private int size = 0;
    @Nullable
    private transient ValuesView valuesView = null;

    public Nat2IntDenseArrayMap(int[] array) {
        this.array = array;
        for (int value : array) {
            if (this.isAbsent(value)) continue;
            ++this.size;
        }
    }

    public Nat2IntDenseArrayMap(int size) {
        this.array = new int[size];
        Arrays.fill(this.array, Integer.MIN_VALUE);
    }

    public Nat2IntDenseArrayMap(int size, int initialValue) {
        this.checkNotAbsent(initialValue);
        this.array = new int[size];
        if (initialValue != 0) {
            Arrays.fill(this.array, initialValue);
        }
        this.size = size;
    }

    public Nat2IntDenseArrayMap(int size, IntUnaryOperator initialValues) {
        this.array = new int[size];
        for (int i = 0; i < this.array.length; ++i) {
            int value = initialValues.applyAsInt(i);
            this.checkNotAbsent(value);
            this.array[i] = value;
        }
        this.size = size;
    }

    private void checkNotAbsent(int value) {
        if (this.isAbsent(value)) {
            throw new IllegalArgumentException(String.format("Value %d not allowed", value));
        }
    }

    public void clear() {
        Arrays.fill(this.array, Integer.MIN_VALUE);
        this.size = 0;
    }

    public boolean containsKey(int key) {
        return 0 <= key && key < this.array.length && !this.isAbsent(this.array[key]);
    }

    public boolean containsValue(int v) {
        if (this.isAbsent(v)) {
            return false;
        }
        for (int value : this.array) {
            if (value != v) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Nat2IntDenseArrayMap) {
            Nat2IntDenseArrayMap other = (Nat2IntDenseArrayMap)((Object)o);
            return this.size == other.size && Arrays.equals(this.array, other.array);
        }
        return super.equals(o);
    }

    public void fill(int from, int to, int value) {
        this.checkNotAbsent(value);
        Arrays.fill(this.array, from, to, value);
    }

    public void fill(PrimitiveIterator.OfInt iterator, int value) {
        this.checkNotAbsent(value);
        while (iterator.hasNext()) {
            this.array[iterator.next().intValue()] = value;
        }
    }

    public int get(int key) {
        int value = this.array[key];
        return this.isAbsent(value) ? this.defaultReturnValue() : value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array) ^ HashCommon.mix((int)this.size);
    }

    public ObjectSet<Int2IntMap.Entry> int2IntEntrySet() {
        if (this.entriesView == null) {
            this.entriesView = new EntrySetView(this);
        }
        return new EntrySetView(this);
    }

    private boolean isAbsent(int value) {
        return value == Integer.MIN_VALUE;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntSet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySetView(this);
        }
        return this.keySetView;
    }

    private int nextKey(int index) {
        for (int i = index; i < this.array.length; ++i) {
            if (this.isAbsent(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    public int put(int key, int value) {
        this.checkNotAbsent(value);
        int previous = this.array[key];
        this.array[key] = value;
        if (this.isAbsent(previous)) {
            ++this.size;
            return this.defaultReturnValue();
        }
        return previous;
    }

    public int remove(int key) {
        int previous = this.array[key];
        if (this.isAbsent(previous)) {
            return this.defaultReturnValue();
        }
        this.array[key] = Integer.MIN_VALUE;
        --this.size;
        return previous;
    }

    public int size() {
        return this.size;
    }

    public IntCollection values() {
        if (this.valuesView == null) {
            this.valuesView = new ValuesView(this);
        }
        return this.valuesView;
    }

    private static class EntrySetView
    extends AbstractInt2IntEntrySet<Nat2IntDenseArrayMap> {
        EntrySetView(Nat2IntDenseArrayMap map) {
            super(map);
        }

        public EntrySetView clone() throws CloneNotSupportedException {
            return (EntrySetView)super.clone();
        }

        public ObjectIterator<Int2IntMap.Entry> fastIterator() {
            return new FastEntryIterator((Nat2IntDenseArrayMap)this.map);
        }

        public ObjectIterator<Int2IntMap.Entry> iterator() {
            return new EntryIterator((Nat2IntDenseArrayMap)this.map);
        }
    }

    private static class KeySetView
    extends AbstractIntSet {
        private final Nat2IntDenseArrayMap map;

        KeySetView(Nat2IntDenseArrayMap map) {
            this.map = map;
        }

        public KeySetView clone() {
            return this;
        }

        public void forEach(IntConsumer action) {
            int index = this.map.nextKey(0);
            while (index >= 0) {
                action.accept(index);
                index = this.map.nextKey(index + 1);
            }
        }

        public IntIterator iterator() {
            return new KeySetIterator(this.map);
        }

        public boolean remove(int key) {
            if (!this.map.containsKey(key)) {
                return false;
            }
            this.map.remove(key);
            return true;
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ValuesView
    extends AbstractIntCollection {
        private final Nat2IntDenseArrayMap map;

        ValuesView(Nat2IntDenseArrayMap map) {
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(int v) {
            return this.map.containsValue(v);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)o;
            return other.size() == this.size() && this.containsAll(other);
        }

        public int hashCode() {
            return HashCommon.mix((int)this.map.hashCode());
        }

        public IntIterator iterator() {
            return new ValuesIterator(this.map);
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ValuesIterator
    implements IntIterator {
        private final Nat2IntDenseArrayMap map;
        private int current;
        private int next;

        ValuesIterator(Nat2IntDenseArrayMap map) {
            this.map = map;
            this.current = -1;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int value = this.map.array[this.next];
            this.current = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return value;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current);
            this.current = -1;
        }
    }

    private static class KeySetIterator
    implements IntIterator {
        private final Nat2IntDenseArrayMap map;
        private int current = -1;
        private int next;

        public KeySetIterator(Nat2IntDenseArrayMap map) {
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return this.current;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current);
            this.current = -1;
        }
    }

    private static class FastMapEntry
    extends AbstractInt2IntMap.BasicEntry {
        private final Nat2IntDenseArrayMap map;
        int index = -1;

        public FastMapEntry(Nat2IntDenseArrayMap map) {
            this.map = map;
        }

        public int getIntKey() {
            return this.index;
        }

        public int getIntValue() {
            return this.map.array[this.index];
        }

        public int setValue(int v) {
            int oldValue = this.map.array[this.index];
            ((Nat2IntDenseArrayMap)this.map).array[this.index] = v;
            return oldValue;
        }
    }

    private static class FastEntryIterator
    implements ObjectIterator<Int2IntMap.Entry> {
        private final FastMapEntry entry;
        private final Nat2IntDenseArrayMap map;
        private int next;

        FastEntryIterator(Nat2IntDenseArrayMap map) {
            this.entry = new FastMapEntry(map);
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public Int2IntMap.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entry.index = this.next;
            this.next = this.map.nextKey(this.next + 1);
            return this.entry;
        }

        public void remove() {
            if (this.entry.index == -1) {
                throw new IllegalStateException();
            }
            this.map.remove(this.entry.index);
            this.entry.index = -1;
        }
    }

    private static class EntryIterator
    implements ObjectIterator<Int2IntMap.Entry> {
        private final Nat2IntDenseArrayMap map;
        private int next;

        EntryIterator(Nat2IntDenseArrayMap map) {
            this.map = map;
            this.next = map.nextKey(0);
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public Int2IntMap.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.next;
            this.next = this.map.nextKey(this.next + 1);
            assert (this.map.containsKey(index));
            return new AbstractInt2IntMap.BasicEntry(index, this.map.array[index]);
        }
    }
}

