/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.NoSuchElementException;

public abstract class AbstractNatBitSet
extends AbstractIntSet
implements NatBitSet {
    @Override
    public int firstInt() {
        int firstPresent = this.nextPresentIndex(0);
        if (firstPresent == -1) {
            throw new NoSuchElementException();
        }
        return firstPresent;
    }

    @Override
    public int lastInt() {
        int lastPresent = this.previousPresentIndex(Integer.MAX_VALUE);
        if (lastPresent == -1) {
            throw new NoSuchElementException();
        }
        return lastPresent;
    }

    @Override
    public boolean add(int index) {
        if (this.contains(index)) {
            return false;
        }
        this.set(index);
        return true;
    }

    @Override
    public void clearFrom(int from) {
        NatBitSetsUtil.checkNonNegative(from);
        this.clear(from, Integer.MAX_VALUE);
    }

    @Override
    public boolean remove(int index) {
        if (!this.contains(index)) {
            return false;
        }
        this.clear(index);
        return true;
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (indices instanceof IntCollection) {
            return IntIterators.any((IntIterator)((IntCollection)indices).iterator(), arg_0 -> ((AbstractNatBitSet)this).contains(arg_0));
        }
        return NatBitSet.super.intersects(indices);
    }

    @Override
    public void and(IntCollection indices) {
        if (indices.isEmpty()) {
            this.clear();
        } else {
            IntIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                int next = iterator.nextInt();
                if (indices.contains(next)) continue;
                iterator.remove();
            }
        }
    }

    public boolean retainAll(IntCollection indices) {
        if (this.isEmpty()) {
            return false;
        }
        if (indices.isEmpty()) {
            this.clear();
            return true;
        }
        int size = this.size();
        this.and(indices);
        return this.size() < size;
    }

    @Override
    public void andNot(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (!indices.contains(next)) continue;
            iterator.remove();
        }
    }

    public boolean removeAll(IntCollection indices) {
        if (this.isEmpty() || indices.isEmpty()) {
            return false;
        }
        int size = this.size();
        this.andNot(indices);
        return this.size() < size;
    }

    @Override
    public void or(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        indices.forEach(this::set);
    }

    public boolean addAll(IntCollection indices) {
        if (indices.isEmpty()) {
            return false;
        }
        int size = this.size();
        this.or(indices);
        return size < this.size();
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        IntSet set = indices instanceof IntSet ? (IntSet)indices : NatBitSets.copyOf((Collection<Integer>)indices);
        set.forEach(this::flip);
    }

    @Override
    public AbstractNatBitSet clone() {
        try {
            return (AbstractNatBitSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

