/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.bitset.RoaringBitmaps;
import de.tum.in.naturals.set.AbstractNatBitSet;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Collection;
import java.util.function.IntConsumer;
import org.roaringbitmap.RoaringBitmap;

class ForwardingNatBitSet
extends AbstractNatBitSet {
    private final IntSortedSet delegate;

    public ForwardingNatBitSet(IntSortedSet delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean add(int key) {
        return this.delegate.add(key);
    }

    @Override
    public boolean addAll(IntCollection o) {
        return this.delegate.addAll(o);
    }

    @Override
    public void and(IntCollection o) {
        this.retainAll(o);
    }

    @Override
    public void andNot(IntCollection o) {
        this.removeAll(o);
    }

    @Override
    public void clear(int index) {
        this.remove(index);
    }

    @Override
    public void clear(int from, int to) {
        IntIterators.fromTo((int)from, (int)to).forEachRemaining(arg_0 -> ((IntSortedSet)this.delegate).remove(arg_0));
    }

    public void clear() {
        this.delegate.clear();
    }

    @Override
    public void clearFrom(int from) {
        this.delegate.tailSet(from).clear();
    }

    @Override
    public ForwardingNatBitSet clone() {
        return new ForwardingNatBitSet((IntSortedSet)new IntAVLTreeSet(this.delegate));
    }

    public boolean contains(int key) {
        return this.delegate.contains(key);
    }

    public boolean containsAll(IntCollection o) {
        return this.delegate.containsAll(o);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int firstInt() {
        return this.delegate.firstInt();
    }

    @Override
    public void flip(int index) {
        if (!this.delegate.remove(index)) {
            this.delegate.add(index);
        }
    }

    @Override
    public void flip(int from, int to) {
        IntIterators.fromTo((int)from, (int)to).forEachRemaining(this::flip);
    }

    public void forEach(IntConsumer action) {
        this.delegate.forEach(action);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean intersects(Collection<Integer> o) {
        return IntIterators.any((IntIterator)this.delegate.iterator(), o::contains);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastInt() {
        return this.delegate.lastInt();
    }

    @Override
    public int nextAbsentIndex(int index) {
        int i = index;
        while (this.delegate.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public int nextPresentIndex(int index) {
        IntSortedSet tail = this.delegate.tailSet(index);
        return tail.isEmpty() ? -1 : tail.firstInt();
    }

    @Override
    public void or(IntCollection o) {
        this.addAll(o);
    }

    @Override
    public int previousAbsentIndex(int index) {
        int i;
        for (i = index; i > -1 && this.delegate.contains(i); --i) {
        }
        return i;
    }

    @Override
    public int previousPresentIndex(int index) {
        IntSortedSet tail = this.delegate.headSet(index);
        return tail.isEmpty() ? -1 : tail.lastInt();
    }

    @Override
    public boolean remove(int k) {
        return this.delegate.remove(k);
    }

    @Override
    public boolean removeAll(IntCollection o) {
        return this.delegate.removeAll(o);
    }

    @Override
    public boolean retainAll(IntCollection o) {
        return this.delegate.retainAll(o);
    }

    @Override
    public void set(int index) {
        this.add(index);
    }

    @Override
    public void set(int index, boolean value) {
        if (value) {
            this.add(index);
        } else {
            this.remove(index);
        }
    }

    @Override
    public void set(int from, int to) {
        IntIterators.fromTo((int)from, (int)to).forEachRemaining(arg_0 -> ((IntSortedSet)this.delegate).add(arg_0));
    }

    public int size() {
        return this.delegate.size();
    }

    public int[] toArray(int[] a) {
        return this.delegate.toArray(a);
    }

    public int[] toIntArray() {
        return this.delegate.toIntArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void xor(IntCollection o) {
        RoaringBitmap our = RoaringBitmaps.of((IntIterable)this);
        RoaringBitmap other = RoaringBitmaps.of((IntIterable)o);
        this.clear();
        our.xor(other);
        our.forEach(this::set);
    }
}

