/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.run.Environment;
import owl.util.BitSetUtil;

public class ForwardDirectSimulation<S>
implements SimulationType<S, SimulationStates.MultipebbleSimulationState<S>> {
    final Automaton<S, BuchiAcceptance> leftAutomaton;
    final Automaton<S, BuchiAcceptance> rightAutomaton;
    final ValuationSetFactory factory;
    final S leftState;
    final S rightState;
    final SimulationStates.MultipebbleSimulationState<S> initialState;
    final SimulationStates.MultipebbleSimulationState<S> sinkState;
    final int pebbleCount;
    final Set<Pair<S, S>> knownPairs;

    public ForwardDirectSimulation(Automaton<S, BuchiAcceptance> leftAutomaton, Automaton<S, BuchiAcceptance> rightAutomaton, S left, S right, int pebbleCount, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.pebbleCount = pebbleCount;
        this.knownPairs = known;
        this.factory = Environment.annotated().factorySupplier().getValuationSetFactory(List.of("a"));
        this.initialState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, false), MultiPebble.of(List.of(Pebble.of(right, false)), pebbleCount));
        this.sinkState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, true), MultiPebble.of(List.of(), pebbleCount));
    }

    @Override
    public Map<Edge<SimulationStates.MultipebbleSimulationState<S>>, ValuationSet> edgeMap(SimulationStates.MultipebbleSimulationState<S> state) {
        HashMap<Edge<SimulationStates.MultipebbleSimulationState<S>>, ValuationSet> out = new HashMap<Edge<SimulationStates.MultipebbleSimulationState<S>>, ValuationSet>();
        if (state.equals(this.sinkState)) {
            out.put(Edge.of(this.sinkState, 1), this.factory.universe());
            return out;
        }
        if (state.owner().isOdd()) {
            if (1 == state.even().count() && this.knownPairs.contains(Pair.of(state.odd().state(), state.even().onlyState()))) {
                out.put(Edge.of(state, 0), this.factory.universe());
                return out;
            }
            if (!state.even().flag() && state.odd().flag()) {
                out.put(Edge.of(this.sinkState, 1), this.factory.universe());
                return out;
            }
            this.leftAutomaton.edgeMap(state.odd().state()).forEach((edge, valSet) -> valSet.forEach(valuation -> {
                SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(Pebble.of(edge.successor(), this.leftAutomaton.acceptance().isAcceptingEdge((Edge<?>)edge)), state.even().setFlag(false), valuation);
                out.put(Edge.of(target, 0), this.factory.universe());
            }));
        } else {
            Set<MultiPebble<S>> possibilities = state.even().successors(this.rightAutomaton, BitSetUtil.fromInt(state.valuation()));
            if (possibilities.size() == 0) {
                out.put(Edge.of(this.sinkState, 1), this.factory.universe());
                return out;
            }
            possibilities.forEach(p -> {
                HashSet ensureSucc = new HashSet();
                state.even().pebbles().forEach(ps -> ensureSucc.addAll(this.rightAutomaton.successors(ps.state())));
                p.pebbles().forEach(peb -> {
                    if (!ensureSucc.contains(peb.state())) {
                        throw new AssertionError((Object)"successor calculation broken");
                    }
                });
                if (!state.odd().flag() || p.flag()) {
                    SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(state.odd(), p);
                    out.put(Edge.of(target, 0), this.factory.universe());
                } else {
                    out.put(Edge.of(this.sinkState, 1), this.factory.universe());
                }
            });
        }
        return out;
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> states() {
        return SimulationStates.MultipebbleSimulationState.universe(Pebble.universe(this.leftAutomaton), MultiPebble.universe(this.rightAutomaton, this.pebbleCount), this.leftAutomaton.factory().universe());
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(2, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }

    @Override
    public ValuationSetFactory factory() {
        return this.factory;
    }

    public static <S> ForwardDirectSimulation<S> of(Automaton<S, BuchiAcceptance> leftAutomaton, Automaton<S, BuchiAcceptance> rightAutomaton, S leftState, S rightState, int pebbleCount, Set<Pair<S, S>> known) {
        return new ForwardDirectSimulation<S>(leftAutomaton, rightAutomaton, leftState, rightState, pebbleCount, known);
    }
}

