/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.factories.Factories;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.run.Environment;
import owl.translations.canonical.AbstractPortfolio;
import owl.translations.canonical.GenericConstructions;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.canonical.RoundRobinState;

public final class NonDeterministicConstructionsPortfolio<A extends OmegaAcceptance>
extends AbstractPortfolio<A> {
    public NonDeterministicConstructionsPortfolio(Class<A> acceptance, Environment environment) {
        super(acceptance, environment);
    }

    @Override
    public Optional<Automaton<?, A>> apply(LabelledFormula formula) {
        Collection<Formula> formulas;
        if (this.isAllowed(AllAcceptance.class) && SyntacticFragments.isSafety(formula.formula())) {
            return this.box(NonDeterministicConstructionsPortfolio.safety(this.environment, formula));
        }
        if (this.isAllowed(BuchiAcceptance.class) && SyntacticFragments.isCoSafety(formula.formula())) {
            return this.box(NonDeterministicConstructionsPortfolio.coSafety(this.environment, formula));
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrappedFormula = formula.formula();
            while (unwrappedFormula instanceof XOperator) {
                ++xCount;
                unwrappedFormula = ((XOperator)unwrappedFormula).operand();
            }
            int xCountFinal = xCount;
            return this.apply(formula.wrap(unwrappedFormula)).map(x -> GenericConstructions.delay(x, xCountFinal));
        }
        Collection<Formula> collection = formulas = formula.formula() instanceof Conjunction ? formula.formula().operands : Set.of(formula.formula());
        if (this.isAllowed(GeneralizedBuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return this.box(NonDeterministicConstructionsPortfolio.gfCoSafety(this.environment, formula, true));
        }
        if (this.isAllowed(BuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return this.box(NonDeterministicConstructionsPortfolio.gfCoSafety(this.environment, formula, false));
        }
        if (this.isAllowed(BuchiAcceptance.class) && SyntacticFragments.isFgSafety(formula.formula())) {
            return this.box(NonDeterministicConstructionsPortfolio.fgSafety(this.environment, formula));
        }
        return Optional.empty();
    }

    public static Automaton<Formula, BuchiAcceptance> coSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.atomicPropositions());
        return NonDeterministicConstructions.CoSafety.of(factories, formula.formula());
    }

    public static Automaton<Formula, AllAcceptance> safety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.atomicPropositions());
        return NonDeterministicConstructions.Safety.of(factories, formula.formula());
    }

    public static Automaton<RoundRobinState<Formula>, GeneralizedBuchiAcceptance> gfCoSafety(Environment environment, LabelledFormula formula, boolean generalized) {
        Factories factories = environment.factorySupplier().getFactories(formula.atomicPropositions());
        Set<Formula> formulas = formula.formula() instanceof Conjunction ? Set.copyOf(formula.formula().operands) : Set.of(formula.formula());
        return NonDeterministicConstructions.GfCoSafety.of(factories, formulas, generalized);
    }

    public static Automaton<Formula, BuchiAcceptance> fgSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.atomicPropositions());
        return NonDeterministicConstructions.FgSafety.of(factories, formula.formula());
    }
}

