/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;

public final class MutableAutomatonUtil {
    private MutableAutomatonUtil() {
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> asMutable(Automaton<S, A> automaton) {
        if (automaton instanceof MutableAutomaton) {
            return (MutableAutomaton)automaton;
        }
        return HashMapAutomaton.copyOf(automaton);
    }

    public static <S> Optional<S> complete(MutableAutomaton<S, ?> automaton, S sinkState) {
        Map<S, ValuationSet> incompleteStates;
        if (automaton.initialStates().isEmpty()) {
            automaton.addInitialState(sinkState);
        }
        if ((incompleteStates = AutomatonUtil.getIncompleteStates(automaton)).isEmpty()) {
            return Optional.empty();
        }
        Edge sinkEdge = Edge.of(sinkState, ((OmegaAcceptance)automaton.acceptance()).rejectingSet().orElseThrow());
        incompleteStates.forEach((state, valuation) -> automaton.addEdge((Object)state, (ValuationSet)valuation, sinkEdge));
        automaton.addEdge(sinkState, automaton.factory().universe(), sinkEdge);
        return Optional.of(sinkState);
    }

    public static <S> void copyInto(Automaton<S, ?> source, MutableAutomaton<S, ?> target) {
        source.accept((Automaton.Visitor<S>)new CopyVisitor<S>(target));
    }

    private static final class CopyVisitor<S>
    implements Automaton.EdgeVisitor<S>,
    Automaton.EdgeMapVisitor<S> {
        private final MutableAutomaton<S, ?> target;

        private CopyVisitor(MutableAutomaton<S, ?> target) {
            this.target = target;
        }

        @Override
        public void visit(S state, BitSet valuation, Edge<S> edge) {
            this.target.addEdge(state, valuation, edge);
        }

        @Override
        public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
            edgeMap.forEach((x, y) -> this.target.addEdge((Object)state, (ValuationSet)y, (Edge<Object>)x));
        }

        @Override
        public void enter(S state) {
            this.target.addState(state);
        }
    }

    public static final class Sink {
        public String toString() {
            return "Sink";
        }
    }
}

