/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.edge.Edge;

public final class RabinAcceptance
extends GeneralizedRabinAcceptance {
    private RabinAcceptance(List<GeneralizedRabinAcceptance.RabinPair> pairs) {
        super(pairs);
        Preconditions.checkArgument((this.acceptanceSets() == 2 * this.pairs.size() ? 1 : 0) != 0);
        for (GeneralizedRabinAcceptance.RabinPair pair : this.pairs) {
            Preconditions.checkArgument((pair.finSet() + 1 == pair.infSet() ? 1 : 0) != 0);
        }
    }

    public static RabinAcceptance of(int count) {
        ArrayList<GeneralizedRabinAcceptance.RabinPair> pairs = new ArrayList<GeneralizedRabinAcceptance.RabinPair>(count);
        for (int index = 0; index < count; ++index) {
            pairs.add(GeneralizedRabinAcceptance.RabinPair.of(index * 2));
        }
        return new RabinAcceptance(pairs);
    }

    public static RabinAcceptance of(List<GeneralizedRabinAcceptance.RabinPair> pairs) {
        return new RabinAcceptance(pairs);
    }

    public static RabinAcceptance of(GeneralizedRabinAcceptance.RabinPair ... pairs) {
        return RabinAcceptance.of(List.of(pairs));
    }

    public static RabinAcceptance of(BooleanExpression<AtomAcceptance> expression) {
        Builder builder = new Builder();
        int setCount = 0;
        for (BooleanExpression<AtomAcceptance> pair : BooleanExpressions.getDisjuncts(expression)) {
            int fin = -1;
            int inf = -1;
            block5: for (BooleanExpression<AtomAcceptance> element : BooleanExpressions.getConjuncts(pair)) {
                AtomAcceptance atom = (AtomAcceptance)element.getAtom();
                switch (atom.getType()) {
                    case TEMPORAL_FIN: {
                        Preconditions.checkArgument((fin == -1 ? 1 : 0) != 0);
                        fin = atom.getAcceptanceSet();
                        Preconditions.checkArgument((fin == setCount ? 1 : 0) != 0);
                        ++setCount;
                        continue block5;
                    }
                    case TEMPORAL_INF: {
                        Preconditions.checkArgument((inf == -1 ? 1 : 0) != 0);
                        inf = atom.getAcceptanceSet();
                        Preconditions.checkArgument((inf == setCount ? 1 : 0) != 0);
                        ++setCount;
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Rabin Acceptance not well-formed.");
            }
            Preconditions.checkArgument((fin >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((inf >= 0 ? 1 : 0) != 0);
            builder.add();
        }
        return builder.build();
    }

    @Override
    public String name() {
        return "Rabin";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(Integer.valueOf(this.pairs.size()));
    }

    @Override
    public boolean isWellFormedEdge(Edge<?> edge) {
        return edge.largestAcceptanceSet() < 2 * this.pairs.size();
    }

    public static final class Builder {
        private final List<GeneralizedRabinAcceptance.RabinPair> pairs = new ArrayList<GeneralizedRabinAcceptance.RabinPair>();
        private int sets;

        public GeneralizedRabinAcceptance.RabinPair add() {
            GeneralizedRabinAcceptance.RabinPair pair = new GeneralizedRabinAcceptance.RabinPair(this.sets, this.sets + 1);
            this.pairs.add(pair);
            this.sets += 2;
            return pair;
        }

        public RabinAcceptance build() {
            return RabinAcceptance.of(this.pairs);
        }
    }
}

