/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.parser;

import java.util.stream.Collectors;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.Negation;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.parser.PreprocessorVisitor;
import owl.ltl.visitors.Visitor;

public final class LtlfToLtlTranslator {
    private LtlfToLtlTranslator() {
    }

    public static Formula translate(Formula in, int tailAtomicProposition) {
        Literal tail = Literal.of(tailAtomicProposition);
        LtlfToLtlVisitor bou = new LtlfToLtlVisitor(tail);
        PreprocessorVisitor p = new PreprocessorVisitor();
        return Conjunction.of((Formula)tail, Conjunction.of(WOperator.of(tail, GOperator.of(tail.not())), Conjunction.of(FOperator.of(tail.not()), (Formula)bou.apply((Formula)p.apply(in)))));
    }

    public static class LtlfToLtlVisitor
    implements Visitor<Formula> {
        private final Literal tail;

        public LtlfToLtlVisitor(Literal tail) {
            this.tail = tail;
        }

        @Override
        public Formula visit(Biconditional biconditional) {
            return Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(FOperator fOperator) {
            if (fOperator.operand() instanceof GOperator) {
                GOperator GOperand = (GOperator)fOperator.operand();
                return FOperator.of(Conjunction.of(this.tail, XOperator.of(this.tail.not()), GOperand.operand().accept(this)));
            }
            if (fOperator.operand() instanceof FOperator) {
                return fOperator.operand().accept(this);
            }
            if (fOperator.operand() instanceof Negation) {
                Negation NegOperand = (Negation)fOperator.operand();
                if (NegOperand.operand() instanceof FOperator) {
                    FOperator FOperand = (FOperator)NegOperand.operand();
                    return FOperator.of(Conjunction.of(this.tail, XOperator.of(this.tail.not()), new Negation(FOperand.operand()).accept(this)));
                }
                if (NegOperand.operand() instanceof XOperator) {
                    return BooleanConstant.TRUE;
                }
            }
            return FOperator.of(Conjunction.of(fOperator.operand().accept(this), (Formula)this.tail));
        }

        @Override
        public Formula visit(GOperator gOperator) {
            Negation NegOperand;
            if (gOperator.operand() instanceof FOperator) {
                FOperator FOperand = (FOperator)gOperator.operand();
                return FOperator.of(Conjunction.of(this.tail, XOperator.of(this.tail.not()), FOperand.operand().accept(this)));
            }
            if (gOperator.operand() instanceof GOperator) {
                return gOperator.operand().accept(this);
            }
            if (gOperator.operand() instanceof Negation && (NegOperand = (Negation)gOperator.operand()).operand() instanceof GOperator) {
                GOperator GOperand = (GOperator)NegOperand.operand();
                return FOperator.of(Conjunction.of(this.tail, XOperator.of(this.tail.not()), new Negation(GOperand.operand()).accept(this)));
            }
            if (gOperator.operand() instanceof XOperator) {
                return BooleanConstant.FALSE;
            }
            return UOperator.of(gOperator.operand().accept(this), this.tail.not());
        }

        @Override
        public Formula visit(Literal literal) {
            return literal;
        }

        @Override
        public Formula visit(MOperator mOperator) {
            return MOperator.of(Conjunction.of((Formula)this.tail, mOperator.leftOperand().accept(this)), mOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(ROperator rOperator) {
            return MOperator.of(Disjunction.of(XOperator.of(this.tail.not()), rOperator.leftOperand().accept(this)), rOperator.rightOperand().accept(this));
        }

        @Override
        public Formula visit(UOperator uOperator) {
            return UOperator.of(uOperator.leftOperand().accept(this), Conjunction.of((Formula)this.tail, uOperator.rightOperand().accept(this)));
        }

        @Override
        public Formula visit(WOperator wOperator) {
            return UOperator.of(wOperator.leftOperand().accept(this), Disjunction.of((Formula)this.tail.not(), wOperator.rightOperand().accept(this)));
        }

        @Override
        public Formula visit(XOperator xOperator) {
            if (xOperator.operand() instanceof XOperator) {
                return XOperator.of(xOperator.operand().accept(this));
            }
            return XOperator.of(Conjunction.of((Formula)this.tail, xOperator.operand().accept(this)));
        }

        @Override
        public Formula visit(Negation negation) {
            if (negation.operand() instanceof XOperator) {
                Negation operatorOfX = new Negation(((XOperator)negation.operand()).operand());
                if (((XOperator)negation.operand()).operand() instanceof XOperator) {
                    return XOperator.of(((Formula)operatorOfX).accept(this));
                }
                return XOperator.of(Disjunction.of(((Formula)operatorOfX).accept(this), (Formula)this.tail.not()));
            }
            PushNegOneDownVisitor n = new PushNegOneDownVisitor();
            return ((Formula)n.apply(negation.operand())).accept(this);
        }

        public static class PushNegOneDownVisitor
        implements Visitor<Formula> {
            @Override
            public Formula visit(Biconditional biconditional) {
                return new Biconditional(biconditional.leftOperand(), new Negation(biconditional.rightOperand()));
            }

            @Override
            public Formula visit(BooleanConstant booleanConstant) {
                return booleanConstant.not();
            }

            @Override
            public Formula visit(Conjunction conjunction) {
                return new Disjunction(conjunction.operands.stream().map(Negation::new).collect(Collectors.toUnmodifiableSet()));
            }

            @Override
            public Formula visit(Disjunction disjunction) {
                return new Conjunction(disjunction.operands.stream().map(Negation::new).collect(Collectors.toUnmodifiableSet()));
            }

            @Override
            public Formula visit(FOperator fOperator) {
                return new GOperator(new Negation(fOperator.operand()));
            }

            @Override
            public Formula visit(GOperator gOperator) {
                return new FOperator(new Negation(gOperator.operand()));
            }

            @Override
            public Formula visit(Literal literal) {
                return literal.not();
            }

            @Override
            public Formula visit(MOperator mOperator) {
                return new WOperator(new Negation(mOperator.leftOperand()), new Negation(mOperator.rightOperand()));
            }

            @Override
            public Formula visit(ROperator rOperator) {
                return new UOperator(new Negation(rOperator.leftOperand()), new Negation(rOperator.rightOperand()));
            }

            @Override
            public Formula visit(UOperator uOperator) {
                return new ROperator(new Negation(uOperator.leftOperand()), new Negation(uOperator.rightOperand()));
            }

            @Override
            public Formula visit(WOperator wOperator) {
                return new MOperator(new Negation(wOperator.leftOperand()), new Negation(wOperator.rightOperand()));
            }

            @Override
            public Formula visit(Negation negation) {
                return negation.operand();
            }
        }
    }
}

