/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierFactory;
import owl.run.modules.OwlModule;

public final class SimplifierTransformer
implements OwlModule.LabelledFormulaTransformer {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("simplify-ltl", "Rewrites / simplifies LTL formulas", () -> {
        Option modeOption = new Option("m", "mode", true, "Specify the rewrites to be applied by a comma separated list. Possible values are: simple, fairness, fixpoint. By default, the \"fixpoint\" mode is chosen.");
        modeOption.setRequired(false);
        modeOption.setArgs(-2);
        modeOption.setValueSeparator(',');
        return new Options().addOption(modeOption);
    }, (commandLine, environment) -> {
        if (!commandLine.hasOption("mode")) {
            return new SimplifierTransformer(List.of(SimplifierFactory.Mode.SYNTACTIC_FIXPOINT));
        }
        String[] modes = commandLine.getOptionValues("mode");
        ArrayList<SimplifierFactory.Mode> rewrites = new ArrayList<SimplifierFactory.Mode>(modes.length);
        for (String mode : modes) {
            rewrites.add(SimplifierTransformer.parseMode(mode));
        }
        return new SimplifierTransformer(rewrites);
    });
    private final List<SimplifierFactory.Mode> rewrites;

    private SimplifierTransformer(List<SimplifierFactory.Mode> rewrites) {
        this.rewrites = List.copyOf(rewrites);
    }

    private static SimplifierFactory.Mode parseMode(String mode) throws ParseException {
        switch (mode) {
            case "simple": {
                return SimplifierFactory.Mode.SYNTACTIC;
            }
            case "fixpoint": {
                return SimplifierFactory.Mode.SYNTACTIC_FIXPOINT;
            }
            case "fairness": {
                return SimplifierFactory.Mode.SYNTACTIC_FAIRNESS;
            }
        }
        throw new ParseException("Unknown mode " + mode);
    }

    @Override
    public Object transform(LabelledFormula object) {
        LabelledFormula result = object;
        for (SimplifierFactory.Mode rewrite : this.rewrites) {
            result = SimplifierFactory.apply(result, rewrite);
        }
        return result;
    }
}

