/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

import com.google.auto.value.AutoValue;
import owl.util.AutoValue_OwlVersion_NameAndVersion;

public class OwlVersion {
    private static final String MAIN_NAME = "owl";
    private static final String VERSION = "20.06";

    private OwlVersion() {
    }

    public static NameAndVersion getNameAndVersion() {
        String moduleName;
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement main = stack[stack.length - 1];
            moduleName = Class.forName(main.getClassName()).getSimpleName().toLowerCase().replace("module", "");
        }
        catch (ArrayIndexOutOfBoundsException | ClassNotFoundException e) {
            moduleName = null;
        }
        Package owlPackage = OwlVersion.class.getPackage();
        String mainName = owlPackage.getImplementationTitle();
        if (mainName == null) {
            mainName = MAIN_NAME;
        } else if (!mainName.equals(MAIN_NAME)) {
            throw new IllegalStateException("Conflicting main names.");
        }
        String version = owlPackage.getImplementationVersion();
        if (version == null) {
            version = VERSION;
        } else if (!version.equals(VERSION)) {
            throw new IllegalStateException("Conflicting versions.");
        }
        if (moduleName == null) {
            return NameAndVersion.of(mainName, version);
        }
        return NameAndVersion.of(String.format("%s (%s)", moduleName, mainName), version);
    }

    @AutoValue
    public static abstract class NameAndVersion {
        public abstract String name();

        public abstract String version();

        private static NameAndVersion of(String name, String version) {
            return new AutoValue_OwlVersion_NameAndVersion(name, version);
        }
    }
}

