/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.Set;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.algorithm.SccDecomposition;

public final class AnnotatedStateOptimisation {
    private AnnotatedStateOptimisation() {
    }

    public static <S extends AnnotatedState<?>, A extends EmersonLeiAcceptance> MutableAutomaton<S, A> optimizeInitialState(Automaton<S, A> automaton) {
        HashMapAutomaton<Object, A> mutableAutomatonCopy = HashMapAutomaton.copyOf(automaton);
        if (mutableAutomatonCopy.initialStates().isEmpty()) {
            return mutableAutomatonCopy;
        }
        Object originalInitialState = ((AnnotatedState)mutableAutomatonCopy.initialState()).state();
        AnnotatedState candidateInitialState = null;
        int size = mutableAutomatonCopy.states().size();
        for (Set<S> scc : SccDecomposition.of(mutableAutomatonCopy).sccsWithoutTransient()) {
            for (AnnotatedState state : scc) {
                int newSize;
                if (!originalInitialState.equals(state.state()) || (newSize = Views.replaceInitialStates(mutableAutomatonCopy, Set.of(state)).states().size()) >= size) continue;
                candidateInitialState = state;
                size = newSize;
            }
        }
        if (candidateInitialState != null) {
            mutableAutomatonCopy.initialStates(Set.of(candidateInitialState));
            mutableAutomatonCopy.trim();
        }
        return mutableAutomatonCopy;
    }
}

