/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.AutomatonUtil;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;

public interface Automaton<S, A extends EmersonLeiAcceptance> {
    public A acceptance();

    public List<String> atomicPropositions();

    public BddSetFactory factory();

    default public S initialState() {
        Iterator<S> iterator = this.initialStates().iterator();
        S first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        throw new IllegalStateException("Multiple initial states: " + this.initialStates().toString());
    }

    public Set<S> initialStates();

    public Set<S> states();

    public Set<Edge<S>> edges(S var1, BitSet var2);

    @Nullable
    default public Edge<S> edge(S state, BitSet valuation) {
        return (Edge)Iterables.getFirst(this.edges(state, valuation), null);
    }

    default public Set<Edge<S>> edges(S state) {
        return this.edgeTree(state).flatValues();
    }

    public Map<Edge<S>, BddSet> edgeMap(S var1);

    public MtBdd<Edge<S>> edgeTree(S var1);

    default public Set<S> successors(S state, BitSet valuation) {
        return Edges.successors(this.edges(state, valuation));
    }

    @Nullable
    default public S successor(S state, BitSet valuation) {
        return (S)Iterables.getFirst(this.successors(state, valuation), null);
    }

    default public Set<S> successors(S state) {
        return Edges.successors(this.edges(state));
    }

    default public Set<S> predecessors(S successor) {
        HashSet<S> predecessors = new HashSet<S>();
        for (S state : this.states()) {
            if (!this.successors(state).contains(successor)) continue;
            predecessors.add(state);
        }
        return predecessors;
    }

    default public boolean is(Property property) {
        switch (property) {
            case COMPLETE: {
                return !this.initialStates().isEmpty() && AutomatonUtil.getIncompleteStates(this).isEmpty();
            }
            case DETERMINISTIC: {
                return this.initialStates().size() <= 1 && this.is(Property.SEMI_DETERMINISTIC);
            }
            case SEMI_DETERMINISTIC: {
                return AutomatonUtil.getNondeterministicStates(this).isEmpty();
            }
            case LIMIT_DETERMINISTIC: {
                if (this.acceptance() instanceof GeneralizedBuchiAcceptance) {
                    return AutomatonUtil.ldbaSplit(OmegaAcceptanceCast.cast(this, GeneralizedBuchiAcceptance.class)).isPresent();
                }
                return false;
            }
        }
        throw new UnsupportedOperationException("Property detection for " + property + " is not implemented");
    }

    public static enum Property {
        COMPLETE,
        DETERMINISTIC,
        SEMI_DETERMINISTIC,
        LIMIT_DETERMINISTIC;

    }
}

