/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.collections.ImmutableBitSet;

public final class RangedVariableAllocator
implements SymbolicAutomaton.VariableAllocator {
    private final List<SymbolicAutomaton.VariableType> order;

    public RangedVariableAllocator(SymbolicAutomaton.VariableType ... order) {
        this.order = List.of(order);
        Preconditions.checkArgument((Set.copyOf(this.order).size() == 4 ? 1 : 0) != 0);
    }

    @Override
    public SymbolicAutomaton.VariableAllocation allocate(int stateVariables, int atomicPropositions, int colours) {
        return new RangedAllocation(stateVariables, atomicPropositions, colours, this.order);
    }

    private static class RangedAllocation
    implements SymbolicAutomaton.VariableAllocation {
        private final List<SymbolicAutomaton.VariableType> order;
        private final EnumMap<SymbolicAutomaton.VariableType, Integer> fromIndexInclusive;
        private final EnumMap<SymbolicAutomaton.VariableType, Integer> toIndexExclusive;
        private final Map<Set<SymbolicAutomaton.VariableType>, ImmutableBitSet> variables;
        private final int size;

        private RangedAllocation(int stateVariables, int atomicPropositions, int colours, List<SymbolicAutomaton.VariableType> order) {
            this.order = List.copyOf(order);
            this.variables = new HashMap<Set<SymbolicAutomaton.VariableType>, ImmutableBitSet>();
            this.size = 2 * stateVariables + atomicPropositions + colours;
            this.fromIndexInclusive = new EnumMap(SymbolicAutomaton.VariableType.class);
            this.toIndexExclusive = new EnumMap(SymbolicAutomaton.VariableType.class);
            int fromIndex = 0;
            for (SymbolicAutomaton.VariableType type : order) {
                this.fromIndexInclusive.put(type, fromIndex);
                switch (type) {
                    case STATE: 
                    case SUCCESSOR_STATE: {
                        fromIndex += stateVariables;
                        break;
                    }
                    case COLOUR: {
                        fromIndex += colours;
                        break;
                    }
                    case ATOMIC_PROPOSITION: {
                        fromIndex += atomicPropositions;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unreachable.");
                    }
                }
                this.toIndexExclusive.put(type, fromIndex);
            }
        }

        @Override
        public ImmutableBitSet variables(SymbolicAutomaton.VariableType ... types) {
            return this.variables.computeIfAbsent(Set.of(types), variableTypes -> {
                BitSet bitSet = new BitSet();
                for (SymbolicAutomaton.VariableType type : variableTypes) {
                    bitSet.set((int)this.fromIndexInclusive.get((Object)type), this.toIndexExclusive.get((Object)type));
                }
                return ImmutableBitSet.copyOf(bitSet);
            });
        }

        @Override
        public int numberOfVariables() {
            return this.size;
        }

        @Override
        public SymbolicAutomaton.VariableType typeOf(int variable) {
            Objects.checkIndex(variable, this.numberOfVariables());
            for (SymbolicAutomaton.VariableType type : SymbolicAutomaton.VariableType.values()) {
                if (this.fromIndexInclusive.get((Object)type) > variable || this.toIndexExclusive.get((Object)type) <= variable) continue;
                return type;
            }
            throw new AssertionError((Object)"Unreachable");
        }

        @Override
        public BitSet localToGlobal(BitSet bitSet, SymbolicAutomaton.VariableType type) {
            BitSet globalBitSet = new BitSet();
            int offset = this.fromIndexInclusive.get((Object)type);
            int size = this.toIndexExclusive.get((Object)type) - offset;
            for (int i = 0; i < size; ++i) {
                globalBitSet.set(i + offset, bitSet.get(i));
            }
            return globalBitSet;
        }

        @Override
        public ImmutableBitSet globalToLocal(BitSet bitSet, SymbolicAutomaton.VariableType type) {
            int offset;
            BitSet localBitSet = new BitSet();
            int s = this.toIndexExclusive.get((Object)type);
            for (int i = offset = this.fromIndexInclusive.get((Object)type).intValue(); i < s; ++i) {
                localBitSet.set(i - offset, bitSet.get(i));
            }
            return ImmutableBitSet.copyOf(localBitSet);
        }

        @Override
        public List<String> variableNames() {
            ArrayList<String> variablesNames = new ArrayList<String>();
            for (SymbolicAutomaton.VariableType type : this.order) {
                String prefix;
                switch (type) {
                    case ATOMIC_PROPOSITION: {
                        prefix = "ap";
                        break;
                    }
                    case COLOUR: {
                        prefix = "c";
                        break;
                    }
                    case STATE: {
                        prefix = "x";
                        break;
                    }
                    case SUCCESSOR_STATE: {
                        prefix = "x'";
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unreachable.");
                    }
                }
                int variables = this.toIndexExclusive.get((Object)type) - this.fromIndexInclusive.get((Object)type);
                for (int x = 0; x < variables; ++x) {
                    variablesNames.add(prefix + "_" + x);
                }
            }
            return variablesNames;
        }

        @Override
        public int localToGlobal(int variable, SymbolicAutomaton.VariableType type) {
            return variable + this.fromIndexInclusive.get((Object)type);
        }

        @Override
        public int globalToLocal(int variable, SymbolicAutomaton.VariableType type) {
            return variable - this.fromIndexInclusive.get((Object)type);
        }
    }
}

