/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd.jbdd;

import de.tum.in.jbdd.Bdd;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

abstract class JBddGcManagedFactory<V extends JBddNode> {
    final Bdd bdd;
    private final Map<Integer, JBddNodeReference<V>> gcObjects = new HashMap<Integer, JBddNodeReference<V>>();
    private final Map<Integer, V> nonGcObjects = new HashMap<Integer, V>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    JBddGcManagedFactory(Bdd bdd) {
        this.bdd = bdd;
    }

    V canonicalize(V wrapper) {
        int node = wrapper.node();
        if (this.bdd.isNodeRoot(node) || this.bdd.isVariableOrNegated(node)) {
            assert (this.bdd.getReferenceCount(node) == -1) : JBddGcManagedFactory.reportReferenceCountMismatch(-1, this.bdd.getReferenceCount(node));
            return (V)this.nonGcObjects.merge(node, (JBddNode)wrapper, (oldWrapper, newWrapper) -> oldWrapper);
        }
        JBddNodeReference<V> canonicalReference = this.gcObjects.get(node);
        if (canonicalReference == null) {
            assert (this.bdd.getReferenceCount(node) == 0) : JBddGcManagedFactory.reportReferenceCountMismatch(0, this.bdd.getReferenceCount(node));
            this.bdd.reference(node);
        } else {
            assert (this.bdd.getReferenceCount(node) == 1) : JBddGcManagedFactory.reportReferenceCountMismatch(1, this.bdd.getReferenceCount(node));
            JBddNode canonicalWrapper = (JBddNode)canonicalReference.get();
            if (canonicalWrapper == null) {
                canonicalReference.enqueue();
            } else {
                assert (node == canonicalWrapper.node());
                return (V)canonicalWrapper;
            }
        }
        assert (this.bdd.getReferenceCount(node) == 1);
        this.processReferenceQueue(node);
        this.gcObjects.put(node, new JBddNodeReference<V>(wrapper, this.queue));
        assert (this.bdd.getReferenceCount(node) == 1);
        return wrapper;
    }

    @Nullable
    V canonicalWrapper(int node) {
        JBddNode wrapper = (JBddNode)this.nonGcObjects.get(node);
        if (wrapper != null) {
            return (V)wrapper;
        }
        JBddNodeReference<V> reference = this.gcObjects.get(node);
        return (V)(reference == null ? null : (JBddNode)reference.get());
    }

    private void processReferenceQueue(int protectedNode) {
        Reference<V> reference = this.queue.poll();
        if (reference == null) {
            return;
        }
        do {
            int node = ((JBddNodeReference)reference).node;
            this.gcObjects.remove(node);
            if (node == protectedNode) continue;
            assert (this.bdd.getReferenceCount(node) == 1);
            this.bdd.dereference(node);
            assert (this.bdd.getReferenceCount(node) == 0);
        } while ((reference = this.queue.poll()) != null);
    }

    private static String reportReferenceCountMismatch(int expected, int actual) {
        return String.format("Expected reference count {%d}, but actual count is {%d}.", expected, actual);
    }

    static interface JBddNode {
        public int node();
    }

    private static final class JBddNodeReference<V extends JBddNode>
    extends WeakReference<V> {
        private final int node;

        private JBddNodeReference(V wrapper, ReferenceQueue<? super V> queue) {
            super(wrapper, queue);
            this.node = wrapper.node();
        }
    }
}

