/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jhoafparser.parser.generated.ParseException;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.transformer.ZielonkaTreeTransformations;
import owl.automaton.edge.Edge;
import owl.automaton.hoa.HoaReader;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.cinterface.CDoubleVector;
import owl.cinterface.CDoubleVectorBuilder;
import owl.cinterface.CIntVector;
import owl.cinterface.CIntVectorBuilder;
import owl.cinterface.CIntVectors;
import owl.cinterface.CInterface;
import owl.cinterface.EquivalenceClassEncoder;
import owl.cinterface.StateFeatures;
import owl.collections.Collections3;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;
import owl.ltl.LabelledFormula;
import owl.translations.LtlTranslationRepository;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.ltl2dela.NormalformDELAConstruction;
import owl.translations.ltl2dpa.NormalformDPAConstruction;

@CContext(value=CInterface.CDirectives.class)
public final class CAutomaton {
    private static final String NAMESPACE = "automaton_";
    private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");

    private CAutomaton() {
    }

    @CEntryPoint(name="automaton_parse", documentation={"Read a (deterministic) automaton from a char* serialised in the HOA format.", "Decodes a 0 terminated C char* to a Java string using the platform's default charset.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle parse(IsolateThread thread, CCharPointer cCharPointer) throws ParseException {
        String fieldName;
        int APStringIndex;
        String hoa = CTypeConversion.toJavaString((CCharPointer)cCharPointer);
        BitSet controllableAPIndices = new BitSet();
        String fieldName2 = "controllable-AP: ";
        int controllableAPStringIndex = hoa.indexOf(fieldName2);
        if (controllableAPStringIndex >= 0) {
            String begin = hoa.substring(controllableAPStringIndex + fieldName2.length());
            String indices = begin.substring(0, begin.indexOf(10));
            for (String index : WHITE_SPACE.split(indices)) {
                controllableAPIndices.set(Integer.parseInt(index));
            }
        }
        Preconditions.checkArgument(((APStringIndex = hoa.indexOf(fieldName = "AP: ")) >= 0 ? 1 : 0) != 0, (Object)"Malformed HOA file.");
        String begin = hoa.substring(APStringIndex + fieldName.length());
        String indices = begin.substring(0, begin.indexOf(10));
        String[] splitString = WHITE_SPACE.split(indices);
        int size = Integer.parseInt(splitString[0]);
        ArrayList<String> atomicPropositions = new ArrayList<String>(Arrays.asList(splitString).subList(1, splitString.length));
        Preconditions.checkArgument((atomicPropositions.size() == size ? 1 : 0) != 0, (Object)"Malformed HOA file.");
        ArrayList reorderedAtomicPropositions = new ArrayList();
        ArrayList<String> uncontrollableAp = new ArrayList<String>();
        ArrayList<String> controllableAp = new ArrayList<String>();
        int s = atomicPropositions.size();
        for (int i = 0; i < s; ++i) {
            if (controllableAPIndices.get(i)) {
                controllableAp.add((String)atomicPropositions.get(i));
                continue;
            }
            uncontrollableAp.add((String)atomicPropositions.get(i));
        }
        reorderedAtomicPropositions.addAll(uncontrollableAp);
        reorderedAtomicPropositions.addAll(controllableAp);
        DeterministicAutomatonWrapper<Integer, ?> automaton = DeterministicAutomatonWrapper.of(HoaReader.read(hoa, FactorySupplier.defaultSupplier()::getBddSetFactory, List.copyOf(reorderedAtomicPropositions)), uncontrollableAp.size());
        return ObjectHandles.getGlobal().create(automaton);
    }

    @CEntryPoint(name="automaton_of", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(), -1);
    }

    @CEntryPoint(name="automaton_of0", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, int lookahead) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(), lookahead);
    }

    @CEntryPoint(name="automaton_of1", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, int lookahead, LtlTranslationRepository.Option o1) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(o1), lookahead);
    }

    @CEntryPoint(name="automaton_of2", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, int lookahead, LtlTranslationRepository.Option o1, LtlTranslationRepository.Option o2) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(o1, o2), lookahead);
    }

    @CEntryPoint(name="automaton_of3", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, int lookahead, LtlTranslationRepository.Option o1, LtlTranslationRepository.Option o2, LtlTranslationRepository.Option o3) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(o1, o2, o3), lookahead);
    }

    @CEntryPoint(name="automaton_of4", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, int lookahead, LtlTranslationRepository.Option o1, LtlTranslationRepository.Option o2, LtlTranslationRepository.Option o3, LtlTranslationRepository.Option o4) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(o1, o2, o3, o4), lookahead);
    }

    @CEntryPoint(name="automaton_of5", documentation={"Translate the given formula to deterministic parity automaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, int lookahead, LtlTranslationRepository.Option o1, LtlTranslationRepository.Option o2, LtlTranslationRepository.Option o3, LtlTranslationRepository.Option o4, LtlTranslationRepository.Option o5) {
        return CAutomaton.of(cLabelledFormula, translation, Set.of(o1, o2, o3, o4, o5), lookahead);
    }

    private static ObjectHandle of(ObjectHandle cLabelledFormula, LtlTranslationRepository.LtlToDpaTranslation translation, Set<LtlTranslationRepository.Option> translationOptions, int lookahead) {
        OptionalInt lookaheadOptional = lookahead >= 0 ? OptionalInt.of(lookahead) : OptionalInt.empty();
        LabelledFormula formula = (LabelledFormula)ObjectHandles.getGlobal().get(cLabelledFormula);
        Automaton<?, ParityAcceptance> automaton = translation.translation(ParityAcceptance.class, translationOptions, lookaheadOptional).apply(formula);
        return ObjectHandles.getGlobal().create(DeterministicAutomatonWrapper.of(automaton, -1));
    }

    @CEntryPoint(name="automaton_acceptance_condition", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnAcceptance.class)
    public static Acceptance acceptanceCondition(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).acceptance;
    }

    @CEntryPoint(name="automaton_acceptance_condition_sets", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int acceptanceConditionSets(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return ((EmersonLeiAcceptance)CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.acceptance()).acceptanceSets();
    }

    @CEntryPoint(name="automaton_atomic_propositions", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int atomicPropositions(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.atomicPropositions().size();
    }

    @CEntryPoint(name="automaton_atomic_propositions_uncontrollable_size", documentation={"Atomic propositions of the range [0, s[ are uncontrollable and [s, l[ are controllable, where s is the value returned by this method. -1 is the default return value, when this value cannot be determined."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int atomicPropositionsUncontrollableSize(IsolateThread thread, ObjectHandle cDeterministicAutomaton) {
        return CAutomaton.get((ObjectHandle)cDeterministicAutomaton).uncontrollableApSize;
    }

    @CEntryPoint(name="automaton_atomic_propositions_label", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnUnsignedWord.class)
    public static UnsignedWord atomicPropositions(IsolateThread thread, ObjectHandle cDeterministicAutomaton, int index, CCharPointer buffer, UnsignedWord bufferSize) {
        return CTypeConversion.toCString((CharSequence)CAutomaton.get((ObjectHandle)cDeterministicAutomaton).automaton.atomicPropositions().get(index), (CCharPointer)buffer, (UnsignedWord)bufferSize);
    }

    @CEntryPoint(name="automaton_edge_tree", documentation={"Serialise the edges leaving the given state into a tree buffer, edge buffer, and an ", "optional score buffer. If the scores are not required, the pointer may be set to NULL.", "The pointer returned via the vector_{int,double}_t structures must be freed using", "the method `free_unmanaged_memory`."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnVoid.class)
    public static void edgeTree(IsolateThread thread, ObjectHandle cDeterministicAutomaton, int state, CIntVector cTreeBuffer, CIntVector cEdgeBuffer, CDoubleVector cScoreBuffer) {
        boolean computeScores = cScoreBuffer.isNonNull();
        SerialisedEdgeTree tree = CAutomaton.get(cDeterministicAutomaton).edgeTree(state, computeScores);
        tree.tree.moveTo(cTreeBuffer);
        tree.edges.moveTo(cEdgeBuffer);
        if (tree.scores != null) {
            tree.scores.moveTo(cScoreBuffer);
        }
    }

    @CEntryPoint(name="automaton_extract_features_normal_form_zielonka_construction", documentation={"Returns a feature vector of the same length as the passed state vector. The memory is ", "managed by Java and at the moment there is no API-call to deallocate it."})
    public static ZielonkaNormalFormState extractFeatures(IsolateThread thread, ObjectHandle automatonObjectHandle, CIntVector stateIds) {
        ZielonkaTreeTransformations.ZielonkaState state;
        DeterministicAutomatonWrapper<?, ?> automaton = CAutomaton.get(automatonObjectHandle);
        Preconditions.checkArgument((boolean)stateIds.isNonNull());
        int size = stateIds.size();
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
        ZielonkaTreeTransformations.AutomatonWithZielonkaTreeLookup zielonkaAutomaton = (ZielonkaTreeTransformations.AutomatonWithZielonkaTreeLookup)automaton.automaton;
        ZielonkaNormalFormState decomposedStates = size == 0 ? (ZielonkaNormalFormState)WordFactory.nullPointer() : (ZielonkaNormalFormState)UnmanagedMemory.malloc((UnsignedWord)SizeOf.unsigned(ZielonkaNormalFormState.class).multiply(size));
        ArrayList<ZielonkaTreeTransformations.ZielonkaState> states = new ArrayList<ZielonkaTreeTransformations.ZielonkaState>();
        HashSet<PropositionalFormula<Integer>> stateFormulas = new HashSet<PropositionalFormula<Integer>>();
        HashMap encoders = new HashMap();
        for (int i = 0; i < size; ++i) {
            int stateId = stateIds.elements().read(i);
            if (stateId == -1) {
                state = ZielonkaTreeTransformations.ZielonkaState.of(NormalformDELAConstruction.State.of(PropositionalFormula.falseConstant(), Map.of(), Set.of()), ZielonkaTreeTransformations.Path.of());
            } else if (stateId == -2) {
                state = ZielonkaTreeTransformations.ZielonkaState.of(NormalformDELAConstruction.State.of(PropositionalFormula.trueConstant(), Map.of(), Set.of()), ZielonkaTreeTransformations.Path.of());
            } else {
                Object uncastedState;
                Object s = uncastedState = stateId == 0 && automaton.index2StateMap.isEmpty() ? automaton.automaton.initialState() : automaton.index2StateMap.get(stateId);
                if (!(uncastedState instanceof ZielonkaTreeTransformations.ZielonkaState)) {
                    throw new IllegalArgumentException("feature extraction only works for 'unpublished zielonka'");
                }
                state = (ZielonkaTreeTransformations.ZielonkaState)uncastedState;
            }
            states.add(state);
            stateFormulas.add(((NormalformDELAConstruction.State)state.state()).stateFormula());
            ((NormalformDELAConstruction.State)state.state()).stateMap().forEach((key, breakPointState) -> encoders.computeIfAbsent(key, x -> new EquivalenceClassEncoder()).put((DeterministicConstructions.BreakpointStateRejecting)breakPointState));
        }
        ArrayList<PropositionalFormula> stateFormulasSorted = new ArrayList<PropositionalFormula>(stateFormulas);
        stateFormulasSorted.sort(Comparator.comparingInt(PropositionalFormula::height));
        for (int i = 0; i < size; ++i) {
            state = (ZielonkaTreeTransformations.ZielonkaState)states.get(i);
            PropositionalFormula<Integer> stateFormula = ((NormalformDELAConstruction.State)state.state()).stateFormula();
            Map<Integer, DeterministicConstructions.BreakpointStateRejecting> stateMap = ((NormalformDELAConstruction.State)state.state()).stateMap();
            ImmutableBitSet roundRobinCounters = ((NormalformDELAConstruction.State)state.state()).roundRobinCounters();
            ZielonkaTreeTransformations.Path zielonkaPath = state.path();
            ZielonkaTreeTransformations.ZielonkaTree zielonkaTree = zielonkaAutomaton.lookup(state);
            if (zielonkaTree instanceof ZielonkaTreeTransformations.AlternatingCycleDecomposition) {
                ZielonkaTreeTransformations.AlternatingCycleDecomposition acd = (ZielonkaTreeTransformations.AlternatingCycleDecomposition)zielonkaTree;
                zielonkaPath = acd.restrictPathToSubtree((NormalformDELAConstruction.State)state.state(), zielonkaPath);
            }
            ZielonkaNormalFormState decomposedState = decomposedStates.addressOf(i);
            decomposedState.stateFormula(stateFormulasSorted.indexOf(stateFormula));
            decomposedState.roundRobinCounters(CIntVectors.copyOf(roundRobinCounters));
            decomposedState.zielonkaPath(CIntVectors.copyOf(zielonkaPath.indices()));
            Iterator<Map.Entry<Integer, DeterministicConstructions.BreakpointStateRejecting>> iterator = stateMap.entrySet().iterator();
            ZielonkaNormalFormState.StateMapEntry entries = iterator.hasNext() ? (ZielonkaNormalFormState.StateMapEntry)UnmanagedMemory.malloc((UnsignedWord)SizeOf.unsigned(ZielonkaNormalFormState.StateMapEntry.class).multiply(stateMap.size())) : (ZielonkaNormalFormState.StateMapEntry)WordFactory.nullPointer();
            decomposedState.stateMap(entries);
            decomposedState.stateMapSize(stateMap.size());
            int s = stateMap.size();
            for (int j = 0; j < s; ++j) {
                Map.Entry<Integer, DeterministicConstructions.BreakpointStateRejecting> entry = iterator.next();
                ZielonkaNormalFormState.StateMapEntry cEntry = entries.addressOf(j);
                DeterministicConstructions.BreakpointStateRejecting dbwState = entry.getValue();
                EquivalenceClassEncoder encoder = (EquivalenceClassEncoder)encoders.get(entry.getKey());
                cEntry.key(entry.getKey());
                cEntry.allProfile(CIntVectors.copyOf(encoder.getAllProfile(dbwState)));
                cEntry.rejectingProfile(CIntVectors.copyOf(encoder.getRejectingProfile(dbwState)));
                cEntry.disambiguation(encoder.disambiguation(dbwState));
            }
            assert (!iterator.hasNext());
        }
        return decomposedStates;
    }

    @CEntryPoint(name="automaton_extract_features", documentation={"Signature: ", "boolean (void* automaton, vector_int_t* states, vector_int_t* features)", "Extract features from the given set of states of an automaton. This method returns `true` if the features disambiguate the given state set. If `false` is returned, the caller of the method needs to disambiguate two states with the same set of features by additional means, e.g. by adding extra bits. The caller might request the inclusion of the accepting and rejecting sink by adding OWL_ACCEPTING_SINK and OWL_REJECTING_SINK to the state set. These states are then added on a best-effort basis. [Some automata do not have a canonical accepting and rejecting sinks]", "The encoding of the feature vector is as follows:", "", "|---------------------------------------------------------------------------------------------------------------------|", "| int (state) | feature_type_t | ... | OWL_FEATURE_SEPARATOR | feature_type | ... | OWL_SEPARATOR | int (state) | ... |", "|---------------------------------------------------------------------------------------------------------------------|", "", "Features are then encoded as follows.", "- PERMUTATION: an int sequence of variable length with no duplicates.", "- ROUND_ROBIN_COUNTER: a single int.", "- TEMPORAL_OPERATORS_PROFILE: an int sequence of variable length with no duplicates."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnBoolean.class)
    public static boolean extractFeatures(IsolateThread thread, ObjectHandle automatonObjectHandle, CIntVector states, CIntVector features) {
        if (ImageInfo.inImageCode()) {
            boolean consistentDeclarations;
            boolean bl = consistentDeclarations = -232323 == CInterface.owlSeparator() && -424242 == CInterface.owlFeatureSeparator();
            if (!consistentDeclarations) {
                throw new AssertionError((Object)"C headers declare conflicting constants.");
            }
        }
        DeterministicAutomatonWrapper<?, ?> automaton = CAutomaton.get(automatonObjectHandle);
        HashSet stateObjects = new HashSet();
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            int state2 = states.elements().read(i);
            boolean changed = state2 >= 0 ? stateObjects.add(automaton.index2StateMap.get(state2)) : true;
            Preconditions.checkArgument((boolean)changed, (Object)"'states' vector contains duplicates.");
        }
        CIntVectorBuilder featuresBuilder = new CIntVectorBuilder();
        try {
            Map featuresMap = StateFeatures.extract(stateObjects);
            featuresMap.forEach((state, stateFeatures) -> {
                featuresBuilder.add((int)automaton.state2indexMap.get(state));
                for (StateFeatures.Feature feature : stateFeatures) {
                    featuresBuilder.add(feature.type().getCValue());
                    switch (feature.type()) {
                        case PERMUTATION: {
                            featuresBuilder.addAll(feature.permutation());
                            break;
                        }
                        case ROUND_ROBIN_COUNTER: {
                            featuresBuilder.add(feature.roundRobinCounter());
                            break;
                        }
                        case TEMPORAL_OPERATORS_PROFILE: {
                            featuresBuilder.addAll(feature.temporalOperatorsProfile());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"not reachable.");
                        }
                    }
                    featuresBuilder.add(-424242);
                }
                featuresBuilder.add(-232323);
            });
            featuresBuilder.moveTo(features);
            return Collections3.hasDistinctValues(featuresMap);
        }
        catch (IllegalArgumentException ex) {
            featuresBuilder.moveTo(features);
            return false;
        }
    }

    private static DeterministicAutomatonWrapper<?, ?> get(ObjectHandle cDeterministicAutomaton) {
        return (DeterministicAutomatonWrapper)ObjectHandles.getGlobal().get(cDeterministicAutomaton);
    }

    static class SerialisedEdgeTree {
        final CIntVectorBuilder tree = new CIntVectorBuilder();
        final CIntVectorBuilder edges = new CIntVectorBuilder();
        @Nullable
        final CDoubleVectorBuilder scores;

        SerialisedEdgeTree(boolean computeScores) {
            this.scores = computeScores ? new CDoubleVectorBuilder() : null;
        }
    }

    static final class DeterministicAutomatonWrapper<S, T> {
        static final int ACCEPTING = -2;
        static final int REJECTING = -1;
        static final int INITIAL = 0;
        final Automaton<S, ?> automaton;
        final Acceptance acceptance;
        final int uncontrollableApSize;
        private final Function<? super S, OptionalInt> sinkDetection;
        private final List<S> index2StateMap;
        private final Map<S, Integer> state2indexMap;
        private final ToDoubleFunction<? super Edge<S>> qualityScore;

        private <A extends EmersonLeiAcceptance> DeterministicAutomatonWrapper(Automaton<S, ? extends A> automaton, Acceptance acceptance, Function<? super S, OptionalInt> sinkDetection, ToDoubleFunction<? super Edge<S>> qualityScore, int uncontrollableApSize) {
            Preconditions.checkArgument((automaton.initialStates().size() == 1 ? 1 : 0) != 0);
            assert (automaton.is(Automaton.Property.DETERMINISTIC));
            this.automaton = automaton;
            this.acceptance = acceptance;
            this.sinkDetection = sinkDetection;
            this.qualityScore = qualityScore;
            this.index2StateMap = new ArrayList<S>();
            this.state2indexMap = new HashMap<S, Integer>();
            this.uncontrollableApSize = uncontrollableApSize;
            this.index(automaton.initialState());
            if (ImageInfo.inImageCode()) {
                boolean consistentDeclarations;
                boolean bl = consistentDeclarations = 0 == CInterface.owlInitialState() && -2 == CInterface.owlAcceptingSink() && -1 == CInterface.owlRejectingSink();
                if (!consistentDeclarations) {
                    throw new AssertionError((Object)"C headers declare conflicting constants.");
                }
            }
        }

        static <S> DeterministicAutomatonWrapper<S, ?> of(Automaton<S, ?> automaton, int uncontrollableApSize) {
            Function<Object, OptionalInt> sinkDetection = state -> {
                Set<Set<Edge<Object>>> edgeSetSet = automaton.edgeTree(state).values();
                if (edgeSetSet.size() != 1) {
                    return OptionalInt.empty();
                }
                Set edgeSet = (Set)Iterables.getOnlyElement(edgeSetSet);
                if (edgeSet.isEmpty()) {
                    return OptionalInt.of(-1);
                }
                assert (edgeSet.size() == 1) : "automaton is not deterministic";
                Edge edge = (Edge)Iterables.getOnlyElement((Iterable)edgeSet);
                if (!edge.successor().equals(state)) {
                    return OptionalInt.empty();
                }
                return OptionalInt.of(((EmersonLeiAcceptance)automaton.acceptance()).isAcceptingEdge(edge) ? -2 : -1);
            };
            ToDoubleFunction<Edge> scoring = x -> 0.5;
            if (automaton instanceof ZielonkaTreeTransformations.AutomatonWithZielonkaTreeLookup) {
                scoring = NormalformDPAConstruction.scoringFunction((ZielonkaTreeTransformations.AutomatonWithZielonkaTreeLookup)automaton);
            }
            return new DeterministicAutomatonWrapper(automaton, Acceptance.fromOmegaAcceptance(automaton.acceptance()), sinkDetection, scoring, uncontrollableApSize);
        }

        private int index(@Nullable S state) {
            if (state == null) {
                return -1;
            }
            Integer index = this.state2indexMap.get(state);
            if (index == null) {
                OptionalInt sink = this.sinkDetection.apply(state);
                if (sink.isEmpty()) {
                    index = this.index2StateMap.size();
                    this.index2StateMap.add(state);
                } else {
                    index = sink.getAsInt();
                }
                this.state2indexMap.put(state, index);
            }
            return index;
        }

        private void serialise(MtBdd<Edge<S>> edgeTree, SerialisedEdgeTree buffers, int treeBufferWriteBackPosition, Map<MtBdd<Edge<S>>, Integer> cachedPositions) {
            CIntVectorBuilder treeBuffer = buffers.tree;
            Integer position = cachedPositions.get(edgeTree);
            if (position == null) {
                if (edgeTree instanceof MtBdd.Node) {
                    MtBdd.Node node = (MtBdd.Node)edgeTree;
                    position = treeBuffer.size();
                    treeBuffer.add(node.variable, -1, -1);
                    this.serialise(node.falseChild, buffers, position + 1, cachedPositions);
                    this.serialise(node.trueChild, buffers, position + 2, cachedPositions);
                } else {
                    Edge edge = (Edge)Iterables.getOnlyElement(((MtBdd.Leaf)edgeTree).value, null);
                    CIntVectorBuilder edgeBuffer = buffers.edges;
                    position = -(edgeBuffer.size() / 2 + 1);
                    if (edge == null) {
                        edgeBuffer.add(-1, -1);
                    } else {
                        edgeBuffer.add(this.index(edge.successor()), edge.colours().last().orElse(-1));
                    }
                    CDoubleVectorBuilder scoreBuffer = buffers.scores;
                    if (scoreBuffer != null) {
                        scoreBuffer.add(edge == null ? 0.0 : this.qualityScore.applyAsDouble(edge));
                    }
                }
                cachedPositions.put(edgeTree, position);
            }
            if (treeBufferWriteBackPosition >= 0) {
                treeBuffer.set(treeBufferWriteBackPosition, position);
            }
        }

        SerialisedEdgeTree edgeTree(int stateIndex, boolean computeScores) {
            S state = stateIndex == 0 && this.index2StateMap.isEmpty() ? this.automaton.initialState() : this.index2StateMap.get(stateIndex);
            MtBdd<Edge<S>> edgeTree = this.automaton.edgeTree(state);
            SerialisedEdgeTree serialisedEdgeTree = new SerialisedEdgeTree(computeScores);
            this.serialise(edgeTree, serialisedEdgeTree, -1, new HashMap<MtBdd<Edge<S>>, Integer>());
            return serialisedEdgeTree;
        }
    }

    @CEnum(value="acceptance_t")
    public static enum Acceptance {
        BUCHI,
        CO_BUCHI,
        PARITY_MAX_EVEN,
        PARITY_MAX_ODD,
        PARITY_MIN_EVEN,
        PARITY_MIN_ODD;


        @CEnumValue
        public native int getCValue();

        @CEnumLookup
        public static native Acceptance fromCValue(int var0);

        public static Acceptance fromOmegaAcceptance(EmersonLeiAcceptance acceptance) {
            if (acceptance instanceof BuchiAcceptance) {
                return BUCHI;
            }
            if (acceptance instanceof CoBuchiAcceptance || acceptance instanceof AllAcceptance) {
                return CO_BUCHI;
            }
            if (acceptance instanceof ParityAcceptance) {
                ParityAcceptance parityAcceptance = (ParityAcceptance)acceptance;
                if (parityAcceptance.parity().even()) {
                    if (parityAcceptance.parity().max()) {
                        return PARITY_MAX_EVEN;
                    }
                    return PARITY_MIN_EVEN;
                }
                if (parityAcceptance.parity().max()) {
                    return PARITY_MAX_ODD;
                }
                return PARITY_MIN_ODD;
            }
            throw new IllegalArgumentException();
        }
    }

    @CContext(value=CInterface.CDirectives.class)
    @CStruct(value="zielonka_normal_form_state_t")
    static interface ZielonkaNormalFormState
    extends PointerBase {
        public ZielonkaNormalFormState addressOf(int var1);

        @CField(value="state_formula")
        public int stateFormula();

        @CField(value="state_formula")
        public void stateFormula(int var1);

        @CField(value="state_map")
        public StateMapEntry stateMap();

        @CField(value="state_map")
        public void stateMap(StateMapEntry var1);

        @CField(value="state_map_size")
        public int stateMapSize();

        @CField(value="state_map_size")
        public void stateMapSize(int var1);

        @CField(value="round_robin_counters")
        public CIntVector roundRobinCounters();

        @CField(value="round_robin_counters")
        public void roundRobinCounters(CIntVector var1);

        @CField(value="zielonka_path")
        public CIntVector zielonkaPath();

        @CField(value="zielonka_path")
        public void zielonkaPath(CIntVector var1);

        @CContext(value=CInterface.CDirectives.class)
        @CStruct(value="zielonka_normal_form_state_state_map_entry_t")
        public static interface StateMapEntry
        extends PointerBase {
            public StateMapEntry addressOf(int var1);

            @CField(value="key")
            public int key();

            @CField(value="key")
            public void key(int var1);

            @CField(value="all_profile")
            public CIntVector allProfile();

            @CField(value="all_profile")
            public void allProfile(CIntVector var1);

            @CField(value="rejecting_profile")
            public CIntVector rejectingProfile();

            @CField(value="rejecting_profile")
            public void rejectingProfile(CIntVector var1);

            @CField(value="disambiguation")
            public int disambiguation();

            @CField(value="disambiguation")
            public void disambiguation(int var1);
        }
    }
}

