/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.auto.value.AutoOneOf;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import owl.cinterface.AutoOneOf_StateFeatures_Feature;
import owl.cinterface.CInterface;
import owl.collections.BitSet2;
import owl.collections.Collections3;
import owl.collections.HashTrieMap;
import owl.collections.HashTrieSet;
import owl.collections.TrieMap;
import owl.collections.TrieSet;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.XOperator;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2dpa.AsymmetricRankingState;
import owl.translations.ltl2ldba.AsymmetricProductState;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;

public final class StateFeatures {
    private static final Comparator<List<Formula>> SET_COMPARATOR = Comparator.comparingInt(List::size).thenComparing(Comparators.lexicographical(Formula::compareTo));

    private StateFeatures() {
    }

    static <S> Map<S, List<Feature>> extract(Set<S> states) {
        HashMap<Object, List<Feature>> featuresMap;
        Set<S> castedStates;
        if (states.isEmpty()) {
            return Map.of();
        }
        S sentinel = states.iterator().next();
        if (sentinel instanceof EquivalenceClass) {
            castedStates = states;
            featuresMap = StateFeatures.extract(castedStates, List::of);
        } else if (sentinel instanceof RoundRobinState) {
            castedStates = states;
            featuresMap = StateFeatures.extract(castedStates, x -> List.of(Feature.roundRobinCounter(x.index()), x.state()));
        } else if (sentinel instanceof DeterministicConstructions.BreakpointStateAccepting) {
            castedStates = states;
            featuresMap = StateFeatures.extract(castedStates, x -> List.of(x.all(), x.accepting()));
        } else if (sentinel instanceof DeterministicConstructions.BreakpointStateAcceptingRoundRobin) {
            castedStates = states;
            featuresMap = StateFeatures.extract(castedStates, x -> List.of(x.all(), x.accepting()));
        } else if (sentinel instanceof DeterministicConstructions.BreakpointStateRejecting) {
            castedStates = states;
            featuresMap = StateFeatures.extract(castedStates, x -> List.of(x.all(), x.rejecting()));
        } else if (sentinel instanceof DeterministicConstructions.BreakpointStateRejectingRoundRobin) {
            castedStates = states;
            featuresMap = StateFeatures.extract(castedStates, x -> List.of(x.all(), x.rejecting()));
        } else if (sentinel instanceof AsymmetricRankingState) {
            castedStates = states;
            List ranking = castedStates.stream().flatMap(x -> x.ranking().stream().map(y -> y.evaluatedFixpoints)).distinct().sorted().collect(Collectors.toList());
            Function<AsymmetricRankingState, List> deconstructor = state -> {
                ArrayList<Object> deconstructedState = new ArrayList<Object>(4 * state.ranking().size() + 3);
                ArrayList<Integer> permutation = new ArrayList<Integer>();
                ArrayList<AsymmetricProductState> subStates = new ArrayList<AsymmetricProductState>(state.ranking());
                Iterator subStatesIterator = subStates.iterator();
                while (subStatesIterator.hasNext()) {
                    AsymmetricProductState subState = (AsymmetricProductState)subStatesIterator.next();
                    int index = ranking.indexOf(subState.evaluatedFixpoints);
                    if (permutation.contains(index)) {
                        subStatesIterator.remove();
                        continue;
                    }
                    permutation.add(index);
                }
                deconstructedState.add(Feature.permutation(permutation));
                deconstructedState.add(Feature.roundRobinCounter(state.safetyIndex()));
                deconstructedState.add(state.state());
                subStates.sort(Comparator.comparing(y -> y.evaluatedFixpoints));
                EquivalenceClass trueClass = state.state().factory().of(true);
                EquivalenceClass falseClass = state.state().factory().of(false);
                for (int i = 0; i < subStates.size(); ++i) {
                    AsymmetricEvaluatedFixpoints fixpoint = (AsymmetricEvaluatedFixpoints)ranking.get(i);
                    AsymmetricProductState subState = (AsymmetricProductState)subStates.get(i);
                    if (fixpoint.equals(subState.evaluatedFixpoints)) continue;
                    subStates.add(i, new AsymmetricProductState(0, falseClass, trueClass, List.of(), fixpoint, null));
                }
                for (AsymmetricProductState subState : subStates) {
                    deconstructedState.add(Feature.roundRobinCounter(subState.index));
                    deconstructedState.add(subState.currentCoSafety);
                    deconstructedState.add(subState.safety);
                    deconstructedState.add(subState.nextCoSafety.stream().reduce(trueClass, EquivalenceClass::and));
                }
                return deconstructedState;
            };
            featuresMap = StateFeatures.extract(castedStates, deconstructor);
        } else {
            throw new IllegalArgumentException("Unsupported: " + sentinel.getClass());
        }
        HashMap<EquivalenceClass, List<Feature>> castedMap = StateFeatures.removeCommonFeatures(featuresMap);
        return castedMap;
    }

    private static <S> HashMap<S, List<Feature>> extract(Set<? extends S> states, Function<? super S, ? extends List<Object>> deconstructor) {
        HashMap<Object, List> deconstructorMapping = new HashMap<Object, List>(states.size());
        HashTrieSet<Object> deconstructedStates = new HashTrieSet<Object>();
        states.forEach(state -> {
            List deconstructedState = List.copyOf((Collection)deconstructor.apply((Object)state));
            deconstructedStates.add((Object)deconstructedState);
            deconstructorMapping.put(state, deconstructedState);
        });
        TrieMap<Object, List<Feature>> deconstructedStatesFeatures = StateFeatures.extractFeatures(deconstructedStates);
        HashMap featuresMap = new HashMap(states.size());
        deconstructorMapping.forEach((state, key) -> featuresMap.put(state, List.copyOf((Collection)deconstructedStatesFeatures.get(key))));
        return featuresMap;
    }

    private static TrieMap<Object, List<Feature>> extractFeatures(TrieSet<Object> states) {
        Function<Object, Feature> nodeFeatures;
        HashTrieMap<Object, List<Feature>> combinedFeatures = new HashTrieMap<Object, List<Feature>>();
        if (states.subTries().isEmpty()) {
            if (states.contains(List.of())) {
                combinedFeatures.put((Object)List.of(), (List<Feature>)List.of());
            }
            return combinedFeatures;
        }
        HashMap<Object, TrieMap> subFeatures = new HashMap<Object, TrieMap>();
        states.subTries().forEach((key, value) -> subFeatures.put(key, StateFeatures.extractFeatures(value)));
        Object sentinel = states.subTries().keySet().iterator().next();
        if (sentinel instanceof Feature) {
            nodeFeatures = Feature.class::cast;
        } else if (sentinel instanceof EquivalenceClass) {
            Set<Object> castedKeySet = states.subTries().keySet();
            Map<EquivalenceClass, Feature> featureMap = StateFeatures.extractFeaturesFromEquivalenceClass(castedKeySet);
            nodeFeatures = featureMap::get;
        } else {
            throw new IllegalArgumentException("Unsupported: " + sentinel.getClass());
        }
        subFeatures.forEach((key1, subFeatureTrie) -> subFeatureTrie.forEach((key2, subFeatureList) -> {
            ArrayList<Object> key = new ArrayList<Object>(key2.size() + 1);
            key.add(key1);
            key.addAll((Collection<Object>)key2);
            ArrayList<Feature> features = new ArrayList<Feature>(subFeatureList.size() + 1);
            features.add((Feature)nodeFeatures.apply(key1));
            features.addAll((Collection<Feature>)subFeatureList);
            combinedFeatures.put((Object)key, (List<Feature>)List.copyOf(features));
        }));
        if (states.contains(List.of())) {
            combinedFeatures.put((Object)List.of(), (List<Feature>)List.of());
        }
        return combinedFeatures;
    }

    private static <S> HashMap<S, List<Feature>> removeCommonFeatures(HashMap<S, List<Feature>> map) {
        if (map.isEmpty()) {
            return map;
        }
        ArrayList commonFeatures = new ArrayList(map.values().iterator().next());
        map.entrySet().forEach(entry -> {
            List features = (List)entry.getValue();
            entry.setValue(new ArrayList(features));
            if (commonFeatures.size() > features.size()) {
                commonFeatures.subList(features.size(), commonFeatures.size()).clear();
            }
            assert (commonFeatures.size() <= features.size()) : "Failed to shrink list.";
            int s = commonFeatures.size();
            for (int i = 0; i < s; ++i) {
                if (((Feature)features.get(i)).equals(commonFeatures.get(i))) continue;
                commonFeatures.set(i, null);
            }
        });
        assert (map.values().stream().allMatch(x -> x.size() >= commonFeatures.size()));
        if (commonFeatures.stream().anyMatch(Objects::nonNull)) {
            map.values().forEach(features -> {
                for (int i = commonFeatures.size() - 1; i >= 0; --i) {
                    Feature featureToBeRemoved = (Feature)commonFeatures.get(i);
                    if (featureToBeRemoved == null) continue;
                    Feature removedFeature = (Feature)features.remove(i);
                    assert (featureToBeRemoved.equals(removedFeature));
                }
            });
        }
        return map;
    }

    static Map<EquivalenceClass, Feature> extractFeaturesFromEquivalenceClass(Set<? extends EquivalenceClass> equivalenceClasses) {
        Map<EquivalenceClass, Feature> featuresMapDnf;
        boolean unambiguousDnf;
        Map<EquivalenceClass, Feature> featuresMapCnf = StateFeatures.extractFeaturesFromEquivalenceClass(equivalenceClasses, TemporalOperatorsProfileNormalForm.CNF, false);
        boolean unambiguousCnf = Collections3.hasDistinctValues(featuresMapCnf);
        if (!unambiguousCnf) {
            featuresMapCnf = StateFeatures.extractFeaturesFromEquivalenceClass(equivalenceClasses, TemporalOperatorsProfileNormalForm.CNF, true);
            unambiguousCnf = Collections3.hasDistinctValues(featuresMapCnf);
        }
        if (!(unambiguousDnf = Collections3.hasDistinctValues(featuresMapDnf = StateFeatures.extractFeaturesFromEquivalenceClass(equivalenceClasses, TemporalOperatorsProfileNormalForm.DNF, false)))) {
            featuresMapDnf = StateFeatures.extractFeaturesFromEquivalenceClass(equivalenceClasses, TemporalOperatorsProfileNormalForm.DNF, true);
            unambiguousDnf = Collections3.hasDistinctValues(featuresMapCnf);
        }
        if (unambiguousCnf && !unambiguousDnf) {
            return featuresMapCnf;
        }
        if (unambiguousDnf && !unambiguousCnf) {
            return featuresMapDnf;
        }
        int valuesCnf = 0;
        for (Feature feature : featuresMapCnf.values()) {
            if (feature.temporalOperatorsProfile().isEmpty()) continue;
            valuesCnf = Math.max(valuesCnf, feature.temporalOperatorsProfile().last());
        }
        int valuesDnf = 0;
        for (Feature feature : featuresMapDnf.values()) {
            if (feature.temporalOperatorsProfile().isEmpty()) continue;
            valuesDnf = Math.max(valuesDnf, feature.temporalOperatorsProfile().last());
        }
        if (valuesDnf <= valuesCnf) {
            return featuresMapDnf;
        }
        return featuresMapCnf;
    }

    static Map<EquivalenceClass, Feature> extractFeaturesFromEquivalenceClass(Set<? extends EquivalenceClass> equivalenceClasses, TemporalOperatorsProfileNormalForm type, boolean includeLiterals) {
        if (equivalenceClasses.isEmpty()) {
            return Map.of();
        }
        HashMap<EquivalenceClass, Set> profiles = new HashMap<EquivalenceClass, Set>();
        TreeSet<List<Formula>> ranks = new TreeSet<List<Formula>>(SET_COMPARATOR);
        for (EquivalenceClass equivalenceClass : equivalenceClasses) {
            profiles.put(equivalenceClass, new HashSet());
            for (Set<Formula> clause : type == TemporalOperatorsProfileNormalForm.CNF ? equivalenceClass.conjunctiveNormalForm() : equivalenceClass.disjunctiveNormalForm()) {
                List<Formula> temporalOperators = new ArrayList<Formula>();
                for (Formula literal : clause) {
                    if (!includeLiterals && !(literal instanceof Formula.TemporalOperator)) continue;
                    temporalOperators.add(literal);
                    BiPredicate<Formula, Formula> isLessThan = (x, y) -> {
                        if (includeLiterals && (x instanceof Literal || x instanceof XOperator)) {
                            return false;
                        }
                        return y.anyMatch(x::equals);
                    };
                    temporalOperators = Collections3.maximalElements(temporalOperators, isLessThan);
                }
                temporalOperators.sort(Formula::compareTo);
                ((Set)profiles.get(equivalenceClass)).add(temporalOperators);
                ranks.add(temporalOperators);
            }
        }
        HashMap<EquivalenceClass, Feature> featuresMap = new HashMap<EquivalenceClass, Feature>();
        profiles.forEach((clazz, preProfile) -> {
            BitSet profile = new BitSet();
            int i = 0;
            for (List rank : ranks) {
                if (preProfile.remove(rank)) {
                    profile.set(i);
                }
                ++i;
            }
            assert (preProfile.isEmpty());
            featuresMap.put((EquivalenceClass)clazz, Feature.temporalOperatorsProfileFromBitset(profile));
        });
        return featuresMap;
    }

    @AutoOneOf(value=Type.class)
    public static abstract class Feature
    implements Comparable<Feature> {
        private static final Comparator<Iterable<Integer>> ITERABLE_COMPARATOR = Comparators.lexicographical(Integer::compare);

        Feature() {
        }

        public abstract Type type();

        public abstract List<Integer> permutation();

        public abstract int roundRobinCounter();

        public abstract SortedSet<Integer> temporalOperatorsProfile();

        public static Feature permutation(List<Integer> permutation) {
            List<Integer> permutationCopy = List.copyOf(permutation);
            Preconditions.checkArgument((boolean)permutationCopy.stream().allMatch(x -> x >= 0));
            return AutoOneOf_StateFeatures_Feature.permutation(permutationCopy);
        }

        public static Feature roundRobinCounter(int roundRobinCounter) {
            return AutoOneOf_StateFeatures_Feature.roundRobinCounter(roundRobinCounter);
        }

        public static Feature temporalOperatorsProfile(SortedSet<Integer> temporalOperatorsProfile) {
            return AutoOneOf_StateFeatures_Feature.temporalOperatorsProfile(BitSet2.asSet(BitSet2.copyOf(temporalOperatorsProfile)));
        }

        public static Feature temporalOperatorsProfileFromBitset(BitSet temporalOperatorsProfile) {
            return AutoOneOf_StateFeatures_Feature.temporalOperatorsProfile(BitSet2.asSet(BitSet2.copyOf(temporalOperatorsProfile)));
        }

        public static Feature temporalOperatorsProfileFromBitset(int ... temporalOperatorsProfile) {
            return AutoOneOf_StateFeatures_Feature.temporalOperatorsProfile(BitSet2.asSet(BitSet2.of(temporalOperatorsProfile)));
        }

        @Override
        public int compareTo(Feature o) {
            int comparison = this.type().compareTo(o.type());
            if (comparison != 0) {
                return comparison;
            }
            switch (this.type()) {
                case PERMUTATION: {
                    return ITERABLE_COMPARATOR.compare(this.permutation(), o.permutation());
                }
                case ROUND_ROBIN_COUNTER: {
                    return Integer.compare(this.roundRobinCounter(), o.roundRobinCounter());
                }
                case TEMPORAL_OPERATORS_PROFILE: {
                    return ITERABLE_COMPARATOR.compare(this.temporalOperatorsProfile(), o.temporalOperatorsProfile());
                }
            }
            throw new AssertionError((Object)"Not reachable");
        }

        @CContext(value=CInterface.CDirectives.class)
        @CEnum(value="feature_type_t")
        public static enum Type {
            PERMUTATION,
            ROUND_ROBIN_COUNTER,
            TEMPORAL_OPERATORS_PROFILE;


            @CEnumValue
            public native int getCValue();

            @CEnumLookup
            public static native Type fromCValue(int var0);
        }
    }

    public static enum TemporalOperatorsProfileNormalForm {
        CNF,
        DNF;

    }
}

