/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IntPreOrder {
    private static final IntPreOrder EMPTY = IntPreOrder.finest(0);
    protected final int[][] array;
    protected final int size;
    private final int hashCode;

    IntPreOrder(int[][] array) {
        assert (IntPreOrder.isWellFormed(array));
        this.array = array;
        int length = 0;
        for (int[] partition : array) {
            length += partition.length;
        }
        this.size = length;
        this.hashCode = Arrays.deepHashCode((Object[])array);
    }

    public static IntPreOrder coarsest(int n) {
        int[][] array = new int[1][n];
        for (int i = 0; i < n; ++i) {
            array[0][i] = i;
        }
        return new IntPreOrder(array);
    }

    public static IntPreOrder empty() {
        return EMPTY;
    }

    public static IntPreOrder finest(int n) {
        int[][] array = new int[n][1];
        for (int i = 0; i < n; ++i) {
            array[i][0] = i;
        }
        return new IntPreOrder(array);
    }

    private static boolean isWellFormed(int[][] array) {
        int length = 0;
        int distinctValues = 0;
        HashSet values = new HashSet();
        for (int[] equivClass : array) {
            assert (equivClass.length > 0) : "Empty partition";
            length += equivClass.length;
            Set classValues = IntStream.of(equivClass).boxed().collect(Collectors.toUnmodifiableSet());
            assert (classValues.size() == equivClass.length) : String.format("%s has duplicate values", Arrays.toString(equivClass));
            values.addAll(classValues);
            assert (values.size() == (distinctValues += classValues.size())) : String.format("%s has values in previous classes", Arrays.toString(equivClass));
            int value = equivClass[0];
            for (int i = 1; i < equivClass.length; ++i) {
                assert (equivClass[i] > value) : String.format("%s not sorted", Arrays.toString(equivClass));
                value = equivClass[i];
            }
        }
        assert (distinctValues == length);
        assert (values.equals(IntStream.range(0, distinctValues).boxed().collect(Collectors.toUnmodifiableSet()))) : String.format("Missing values %s", values);
        return true;
    }

    private static String toString(int[][] array) {
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(2 + array.length * 4);
        builder.append('[');
        for (int[] partition : array) {
            assert (partition.length > 0);
            builder.append('{').append(partition[0]);
            for (int i = 1; i < partition.length; ++i) {
                builder.append(',').append(partition[i]);
            }
            builder.append('}');
        }
        builder.append(']');
        return builder.toString();
    }

    public int classes() {
        return this.array.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntPreOrder)) {
            return false;
        }
        IntPreOrder record = (IntPreOrder)o;
        return this.size == record.size && this.hashCode == record.hashCode && Arrays.deepEquals((Object[])this.array, (Object[])record.array);
    }

    public int[] equivalenceClass(int index) {
        return this.array[index];
    }

    private boolean inDomain(int i) {
        return 0 <= i && i < this.size;
    }

    public IntPreOrder generation(Set<Integer> newborn) {
        if (newborn.isEmpty()) {
            return this;
        }
        assert (newborn.stream().allMatch(this::inDomain));
        int newbornCount = newborn.size();
        if (newbornCount == this.size) {
            if (this.array.length == 1) {
                return this;
            }
            return IntPreOrder.coarsest(this.size);
        }
        int[] newbornArray = newborn.stream().mapToInt(x -> x).toArray();
        Arrays.sort(newbornArray);
        if (newbornCount == this.size - 1) {
            int senior = -1;
            for (int i = 0; i < this.size; ++i) {
                if (newborn.contains(i)) continue;
                senior = i;
                break;
            }
            assert (senior != -1);
            return new IntPreOrder(new int[][]{newbornArray, {senior}});
        }
        int[][] newArrayTmp = new int[this.array.length + 1][];
        newArrayTmp[0] = newbornArray;
        int newClassIndex = 1;
        int foundReborn = 0;
        for (int[] equivalenceClass : this.array) {
            if (newbornCount == foundReborn) {
                newArrayTmp[newClassIndex] = equivalenceClass;
                ++newClassIndex;
                continue;
            }
            assert (equivalenceClass.length > 0);
            int newClassSize = 0;
            int[] newClassElements = new int[equivalenceClass.length];
            for (int value : equivalenceClass) {
                if (Arrays.binarySearch(newbornArray, value) >= 0) {
                    ++foundReborn;
                    continue;
                }
                newClassElements[newClassSize] = value;
                ++newClassSize;
            }
            if (newClassSize <= 0) continue;
            newArrayTmp[newClassIndex] = newClassSize < newClassElements.length ? Arrays.copyOf(newClassElements, newClassSize) : equivalenceClass;
            ++newClassIndex;
        }
        int[][] newArray = newClassIndex < newArrayTmp.length ? (Object)((int[][])Arrays.copyOf(newArrayTmp, newClassIndex)) : newArrayTmp;
        return new IntPreOrder(newArray);
    }

    public int hashCode() {
        assert (Arrays.deepHashCode((Object[])this.array) == this.hashCode) : "Array was modified";
        return this.hashCode;
    }

    public boolean refines(IntPreOrder other) {
        if (this == other) {
            return false;
        }
        assert (this.size == other.size);
        int classCount = this.array.length;
        int otherClassCount = other.array.length;
        if (classCount <= otherClassCount) {
            return false;
        }
        int[] otherClassByLength = new int[classCount];
        int otherClassIndex = 0;
        int otherClassSize = other.array[otherClassIndex].length;
        int coveredValues = 0;
        for (int classIndex = 0; classIndex < classCount; ++classIndex) {
            int classSize;
            if (coveredValues == otherClassSize) {
                otherClassSize = other.array[++otherClassIndex].length;
                coveredValues = 0;
            }
            if ((coveredValues += (classSize = this.array[classIndex].length)) > otherClassSize) {
                return false;
            }
            otherClassByLength[classIndex] = otherClassIndex;
        }
        int classIndex = 0;
        for (int otherClassIndex2 = 0; otherClassIndex2 < otherClassCount; ++otherClassIndex2) {
            if (this.array[classIndex].length == other.array[otherClassIndex2].length) {
                if (!Arrays.equals(this.array[classIndex], other.array[otherClassIndex2])) {
                    return false;
                }
                ++classIndex;
                continue;
            }
            while (classIndex < classCount && otherClassByLength[classIndex] == otherClassIndex2) {
                for (int value : this.array[classIndex]) {
                    if (Arrays.binarySearch(other.array[otherClassIndex2], value) >= 0) continue;
                    return false;
                }
                ++classIndex;
            }
        }
        return true;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return IntPreOrder.toString(this.array);
    }
}

