/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jhoafparser.parser.generated.ParseException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import owl.command.AbstractOwlCommand;
import owl.command.AutomatonConversionCommands;
import owl.command.LtlConversionCommands;
import owl.command.LtlTranslationCommands;
import owl.command.MiscCommands;
import picocli.CommandLine;

@CommandLine.Command(name="owl", description={"A tool collection and library for \u03c9-words, \u03c9-automata and linear temporal logic."}, synopsisSubcommandLabel="COMMAND", usageHelpAutoWidth=true, subcommands={LtlTranslationCommands.Ltl2NbaCommand.class, LtlTranslationCommands.Ltl2NgbaCommand.class, LtlTranslationCommands.Ltl2LdbaCommand.class, LtlTranslationCommands.Ltl2LdgbaCommand.class, LtlTranslationCommands.Ltl2DpaCommand.class, LtlTranslationCommands.Ltl2DraCommand.class, LtlTranslationCommands.Ltl2DgraCommand.class, LtlTranslationCommands.Ltl2DelaCommand.class, LtlConversionCommands.Delta2Normalisation.class, AutomatonConversionCommands.Ngba2LdbaCommand.class, AutomatonConversionCommands.Nba2DpaCommand.class, AutomatonConversionCommands.NbaSimCommand.class, AutomatonConversionCommands.Aut2ParityCommand.class, AutomatonConversionCommands.GfgMinimisation.class, MiscCommands.BibliographyCommand.class, MiscCommands.LicenseCommand.class, MiscCommands.DelagMigrationCommand.class, MiscCommands.LtlInspectionCommand.class, LtlConversionCommands.LtlUtilities.class, LtlConversionCommands.RLtlReader.class, MiscCommands.AutInspectionCommand.class, AutomatonConversionCommands.AutUtilities.class, MiscCommands.Automaton2GameCommand.class})
public final class OwlCommand
extends AbstractOwlCommand {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec = null;
    private final List<String> args;

    private OwlCommand() {
        this.args = null;
    }

    public OwlCommand(String[] args) {
        this.args = Arrays.stream(args).filter(Predicate.not(Objects::isNull)).collect(Collectors.toUnmodifiableList());
    }

    public static void main(String[] args) {
        System.exit(new CommandLine(new OwlCommand(args)).setExecutionExceptionHandler(new ExecutionExceptionHandler()).execute(args));
    }

    @Override
    public Integer call() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand.");
    }

    @Override
    protected List<String> rawArgs() {
        return this.args;
    }

    private static class ExecutionExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private ExecutionExceptionHandler() {
        }

        @Override
        public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            return this.handleExecutionException((Throwable)ex, commandLine, parseResult);
        }

        public int handleExecutionException(Throwable ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            if (ex instanceof UncheckedIOException || ex instanceof UncheckedExecutionException) {
                return this.handleExecutionException(ex.getCause(), commandLine, parseResult);
            }
            if (ex instanceof NoSuchFileException) {
                NoSuchFileException exception = (NoSuchFileException)ex;
                String file = exception.getFile();
                String reason = exception.getReason();
                if (reason == null) {
                    System.err.printf("Could not access file \"%s\".", file);
                } else {
                    System.err.printf("Could not access file \"%s\", because of the following reason: %s", file, reason);
                }
            } else if (ex instanceof IllegalArgumentException) {
                if (ex.getCause() instanceof RecognitionException || ex.getCause() instanceof ParseCancellationException) {
                    System.err.printf("Could not parse linear temporal logic formula: %s", ex.getMessage());
                } else {
                    ex.printStackTrace(System.err);
                }
            } else if (ex instanceof ParseException) {
                System.err.printf("Could not parse HOA automaton due to the following problem:%n%s", ex.getMessage());
            } else {
                ex.printStackTrace(System.err);
            }
            System.err.println();
            return -1;
        }
    }
}

