/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.collections.BitSet2;
import owl.collections.Collections3;
import owl.game.AutoValue_GameViews_Node;
import owl.game.Game;

public final class GameViews {
    private GameViews() {
    }

    public static <S, A extends EmersonLeiAcceptance> Game<S, A> filter(Game<S, A> game, Predicate<S> states) {
        return new FilteredGame<S, A>(game, states, x -> true);
    }

    public static <S, A extends EmersonLeiAcceptance> Game<S, A> filter(Game<S, A> game, Predicate<S> states, Predicate<Edge<S>> edgeFilter) {
        return new FilteredGame<S, A>(game, states, edgeFilter);
    }

    public static <S, A extends EmersonLeiAcceptance> Game<Node<S>, A> split(Automaton<S, A> automaton, Collection<String> firstPropositions) {
        return new ForwardingGame<S, A>(automaton, firstPropositions::contains);
    }

    public static <S, A extends EmersonLeiAcceptance> Game<Node<S>, A> split(Automaton<S, A> automaton, Predicate<String> firstPropositions) {
        return new ForwardingGame<S, A>(automaton, firstPropositions);
    }

    public static <S, A extends EmersonLeiAcceptance> Game<S, A> replaceInitialStates(final Game<S, ? extends A> game, Set<S> initialStates) {
        final Set<S> immutableInitialStates = Set.copyOf(initialStates);
        return new Game<S, A>(){

            @Override
            public List<String> atomicPropositions() {
                return game.atomicPropositions();
            }

            @Override
            public A acceptance() {
                return game.acceptance();
            }

            @Override
            public BddSetFactory factory() {
                return game.factory();
            }

            @Override
            public Set<S> initialStates() {
                return immutableInitialStates;
            }

            @Override
            public Set<S> states() {
                return game.states();
            }

            @Override
            public Set<Edge<S>> edges(S state, BitSet valuation) {
                return game.edges(state, valuation);
            }

            @Override
            public Set<Edge<S>> edges(S state) {
                return game.edges(state);
            }

            @Override
            public Map<Edge<S>, BddSet> edgeMap(S state) {
                return game.edgeMap(state);
            }

            @Override
            public MtBdd<Edge<S>> edgeTree(S state) {
                return game.edgeTree(state);
            }

            @Override
            public Game.Owner owner(S state) {
                return game.owner(state);
            }

            @Override
            public BitSet choice(S state, Game.Owner owner) {
                return game.choice(state, owner);
            }

            @Override
            public List<String> variables(Game.Owner owner) {
                return game.variables(owner);
            }
        };
    }

    @AutoValue
    public static abstract class Node<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        @Nullable
        abstract BitSet firstPlayerChoice();

        static <S> Node<S> of(S state) {
            return new AutoValue_GameViews_Node<S>(state, null);
        }

        static <S> Node<S> of(S state, BitSet choice) {
            return new AutoValue_GameViews_Node<S>(state, BitSet2.copyOf(choice));
        }

        public abstract boolean equals(Object var1);

        @Memoized
        public abstract int hashCode();

        public String toString() {
            return this.isFirstPlayersTurn() ? String.format("1:%s", this.state()) : String.format("2%s:%s", this.firstPlayerChoice(), this.state());
        }

        boolean isFirstPlayersTurn() {
            return this.firstPlayerChoice() == null;
        }
    }

    static final class ForwardingGame<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeMapImplementation<Node<S>, A>
    implements Game<Node<S>, A> {
        private final Automaton<S, A> automaton;
        private final BitSet firstPlayer;
        private final BitSet secondPlayer;

        ForwardingGame(Automaton<S, A> automaton, Predicate<String> firstPlayer) {
            super(automaton.atomicPropositions(), automaton.factory(), Collections3.transformSet(automaton.initialStates(), Node::of), automaton.acceptance());
            this.automaton = automaton;
            this.firstPlayer = new BitSet();
            ListIterator<String> iterator = automaton.atomicPropositions().listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex();
                String next = iterator.next();
                if (!firstPlayer.test(next)) continue;
                this.firstPlayer.set(index);
            }
            this.secondPlayer = BitSet2.copyOf(this.firstPlayer);
            this.secondPlayer.flip(0, automaton.atomicPropositions().size());
        }

        @Override
        public Map<Edge<Node<S>>, BddSet> edgeMapImpl(Node<S> node) {
            HashMap<Edge<Node<S>>, BddSet> edges = new HashMap<Edge<Node<S>>, BddSet>();
            BddSetFactory factory = this.automaton.factory();
            if (node.isFirstPlayersTurn()) {
                for (BitSet valuation : BitSet2.powerSet(this.firstPlayer)) {
                    BddSet valuationSet = factory.of(valuation, this.firstPlayer);
                    edges.merge(Edge.of(Node.of(node.state(), valuation)), valuationSet, BddSet::union);
                }
            } else {
                for (BitSet valuation : BitSet2.powerSet(this.secondPlayer)) {
                    BddSet vs = factory.of(valuation, this.secondPlayer);
                    BitSet joined = BitSet2.copyOf(valuation);
                    joined.or(node.firstPlayerChoice());
                    Edge<S> edge = this.automaton.edge(node.state(), joined);
                    Preconditions.checkNotNull(edge, (String)"Automaton not complete in state %s with valuation %s", node.state(), (Object)joined);
                    edges.merge(edge.withSuccessor(Node.of(edge.successor())), vs, BddSet::union);
                }
            }
            return edges;
        }

        @Override
        public Game.Owner owner(Node<S> state) {
            return state.isFirstPlayersTurn() ? Game.Owner.PLAYER_1 : Game.Owner.PLAYER_2;
        }

        @Override
        public Set<Node<S>> predecessors(Node<S> successor) {
            if (!successor.isFirstPlayersTurn()) {
                return Set.of(Node.of(successor.state()));
            }
            HashSet<Node<S>> predecessors = new HashSet<Node<S>>();
            for (S predecessor : this.automaton.states()) {
                this.automaton.edgeMap(predecessor).forEach((edge, valuations) -> {
                    if (successor.state().equals(edge.successor())) {
                        valuations.iterator(this.automaton.atomicPropositions().size()).forEachRemaining(set -> {
                            BitSet localSet = BitSet2.copyOf(set);
                            localSet.and(this.firstPlayer);
                            predecessors.add(Node.of(predecessor, localSet));
                        });
                    }
                });
            }
            return predecessors;
        }

        @Override
        public Set<Node<S>> predecessors(Node<S> state, Game.Owner owner) {
            return owner == this.owner(state) ? Set.of() : this.predecessors(state);
        }

        @Override
        public List<String> variables(Game.Owner owner) {
            ArrayList<String> variables = new ArrayList<String>();
            List<String> elements = this.atomicPropositions();
            int s = elements.size();
            for (int i = 0; i < s; ++i) {
                if (!(owner == Game.Owner.PLAYER_1 ^ !this.firstPlayer.get(i))) continue;
                variables.add(elements.get(i));
            }
            return variables;
        }

        public String toString() {
            return "Arena: " + this.firstPlayer + "/" + this.secondPlayer + "\n" + this.automaton;
        }

        @Override
        public BitSet choice(Node<S> state, Game.Owner owner) {
            Preconditions.checkArgument((state.firstPlayerChoice() != null ? 1 : 0) != 0, (Object)"The state has no encoded choice.");
            if (owner == Game.Owner.PLAYER_1) {
                BitSet choice = state.firstPlayerChoice();
                assert (choice != null);
                return BitSet2.copyOf(choice);
            }
            BddSet valuationSet = (BddSet)((Map.Entry)Iterables.getOnlyElement(this.edgeMap(state).entrySet())).getValue();
            return valuationSet.iterator(this.atomicPropositions.size()).next();
        }
    }

    private static final class FilteredGame<S, A extends EmersonLeiAcceptance>
    implements Game<S, A> {
        private final Automaton<S, A> filteredAutomaton;
        private final Function<S, Game.Owner> ownership;
        private final Function<Game.Owner, List<String>> variableOwnership;
        private final BiFunction<S, Game.Owner, BitSet> choice;

        private FilteredGame(Game<S, A> game, Predicate<S> states, Predicate<Edge<S>> edgeFilter) {
            this.filteredAutomaton = Views.filtered(game, Views.Filter.of(states, (s, e) -> edgeFilter.test((Edge)e)));
            this.ownership = game instanceof FilteredGame ? ((FilteredGame)game).ownership : game::owner;
            this.variableOwnership = game instanceof FilteredGame ? ((FilteredGame)game).variableOwnership : game::variables;
            this.choice = game instanceof FilteredGame ? ((FilteredGame)game).choice : game::choice;
        }

        @Override
        public List<String> atomicPropositions() {
            return this.filteredAutomaton.atomicPropositions();
        }

        @Override
        public BitSet choice(S state, Game.Owner owner) {
            return this.choice.apply(state, owner);
        }

        @Override
        public A acceptance() {
            return this.filteredAutomaton.acceptance();
        }

        @Override
        public Set<S> initialStates() {
            return this.filteredAutomaton.initialStates();
        }

        @Override
        public Map<Edge<S>, BddSet> edgeMap(S state) {
            return this.filteredAutomaton.edgeMap(state);
        }

        @Override
        public Game.Owner owner(S state) {
            return this.ownership.apply(state);
        }

        @Override
        public List<String> variables(Game.Owner owner) {
            return this.variableOwnership.apply(owner);
        }

        @Override
        public BddSetFactory factory() {
            return this.filteredAutomaton.factory();
        }

        @Override
        public Set<S> predecessors(S successor) {
            return this.filteredAutomaton.predecessors(successor);
        }

        @Override
        public Set<S> successors(S state) {
            return this.filteredAutomaton.successors(state);
        }

        @Override
        public Set<S> states() {
            return this.filteredAutomaton.states();
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            return Maps.filterValues(this.edgeMap(state), x -> x.contains(valuation)).keySet();
        }

        @Override
        public MtBdd<Edge<S>> edgeTree(S state) {
            return this.factory().toMtBdd(this.edgeMap(state));
        }
    }
}

