/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.Factories;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.BitSet2;
import owl.collections.Collections3;
import owl.collections.ImmutableBitSet;
import owl.collections.Pair;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.SyntacticSimplifier;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.PropositionalVisitor;
import owl.translations.canonical.RoundRobinState;
import owl.translations.canonical.Util;

public final class NonDeterministicConstructions {
    private NonDeterministicConstructions() {
    }

    public static final class GfCoSafety
    extends Base<RoundRobinState<Formula>, GeneralizedBuchiAcceptance> {
        private final RoundRobinState<Formula> fallbackInitialState;
        private final MtBdd<Pair<List<RoundRobinState<Formula>>, ImmutableBitSet>> initialStatesSuccessorTree;

        private GfCoSafety(Factories factories, Set<RoundRobinState<Formula>> initialState, RoundRobinState<Formula> fallbackInitialState, MtBdd<Pair<List<RoundRobinState<Formula>>, ImmutableBitSet>> tree, GeneralizedBuchiAcceptance acceptance) {
            super(factories, initialState, acceptance);
            this.fallbackInitialState = fallbackInitialState;
            this.initialStatesSuccessorTree = tree;
        }

        /*
         * WARNING - void declaration
         */
        public static GfCoSafety of(Factories factories, Set<? extends Formula> formulas, boolean generalized) {
            void var6_8;
            Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
            ArrayList<FOperator> automata = new ArrayList<FOperator>();
            ArrayList<Formula> singletonAutomata = new ArrayList<Formula>();
            for (Formula formula : formulas) {
                Preconditions.checkArgument((boolean)SyntacticFragments.isGfCoSafety(formula));
                Formula unwrapped = Util.unwrap(Util.unwrap(formula));
                if (generalized && SyntacticFragment.SINGLE_STEP.contains(unwrapped)) {
                    singletonAutomata.add(unwrapped);
                    continue;
                }
                automata.add(new FOperator(unwrapped));
            }
            singletonAutomata.sort(null);
            if (automata.isEmpty()) {
                automata.add(new FOperator((Formula)singletonAutomata.remove(0)));
            } else {
                automata.sort(null);
            }
            MtBdd initialStatesSuccessorTreeTemp = MtBdd.of(Set.of(List.of()));
            boolean bl = false;
            while (var6_8 < automata.size()) {
                void j = var6_8++;
                FOperator initialState = (FOperator)automata.get((int)j);
                MtBdd initialStateSuccessorTree = GfCoSafety.successorTreeInternal(initialState, arg_0 -> GfCoSafety.lambda$of$1((int)j, arg_0), factories.eqFactory);
                initialStatesSuccessorTreeTemp = MtBddOperations.cartesianProduct(initialStatesSuccessorTreeTemp, initialStateSuccessorTree, Collections3::add);
            }
            MtBdd<Pair<List<RoundRobinState<Formula>>, ImmutableBitSet>> mtBdd = MtBddOperations.cartesianProduct(initialStatesSuccessorTreeTemp, Util.singleStepTree(singletonAutomata), (x, y) -> Pair.of(List.copyOf(x), y));
            RoundRobinState<Formula> fallbackInitialState = RoundRobinState.of(0, (Formula)automata.get(0));
            Set<RoundRobinState<Formula>> initialStates = Edges.successors(GfCoSafety.edges(fallbackInitialState, new BitSet(), factories.eqFactory, mtBdd, fallbackInitialState));
            return new GfCoSafety(factories, initialStates, fallbackInitialState, mtBdd, GeneralizedBuchiAcceptance.of(singletonAutomata.size() + 1));
        }

        @Override
        public MtBdd<Edge<RoundRobinState<Formula>>> edgeTreeImpl(RoundRobinState<Formula> state) {
            MtBdd successorTree = this.successorTreeInternal(state.state(), Function.identity());
            return MtBddOperations.cartesianProduct(successorTree, this.initialStatesSuccessorTree, (x, y) -> GfCoSafety.buildEdge(state.index(), x, y, this.fallbackInitialState));
        }

        private static Set<Edge<RoundRobinState<Formula>>> edges(RoundRobinState<Formula> state, BitSet valuation, EquivalenceClassFactory factory, MtBdd<Pair<List<RoundRobinState<Formula>>, ImmutableBitSet>> initialStatesSuccessorTree, RoundRobinState<Formula> fallbackInitialState) {
            HashSet<Edge<RoundRobinState<Formula>>> edges = new HashSet<Edge<RoundRobinState<Formula>>>();
            for (Formula leftSet : GfCoSafety.successorsInternal(state.state(), valuation, Function.identity(), factory)) {
                for (Pair<List<RoundRobinState<Formula>>, ImmutableBitSet> rightSet : initialStatesSuccessorTree.get(valuation)) {
                    edges.add(GfCoSafety.buildEdge(state.index(), leftSet, rightSet, fallbackInitialState));
                }
            }
            return edges;
        }

        private static Edge<RoundRobinState<Formula>> buildEdge(int index, Formula successor, Pair<List<RoundRobinState<Formula>>, ImmutableBitSet> initialStateSuccessors, RoundRobinState<Formula> fallbackInitialState) {
            if (!BooleanConstant.TRUE.equals(successor)) {
                return Edge.of(RoundRobinState.of(index, successor), initialStateSuccessors.snd());
            }
            int size = initialStateSuccessors.fst().size();
            List<RoundRobinState<Formula>> latterSuccessors = initialStateSuccessors.fst().subList(index + 1, size);
            for (RoundRobinState<Formula> initialStateSuccessor : latterSuccessors) {
                if (BooleanConstant.TRUE.equals(initialStateSuccessor.state())) continue;
                return Edge.of(initialStateSuccessor, initialStateSuccessors.snd());
            }
            BitSet acceptance = BitSet2.copyOf(initialStateSuccessors.snd());
            acceptance.set(0);
            List<RoundRobinState<Formula>> earlierSuccessors = initialStateSuccessors.fst().subList(0, index + 1);
            for (RoundRobinState<Formula> initialStateSuccessor : earlierSuccessors) {
                if (BooleanConstant.TRUE.equals(initialStateSuccessor.state())) continue;
                return Edge.of(initialStateSuccessor, acceptance);
            }
            return Edge.of(fallbackInitialState, acceptance);
        }
    }

    public static final class FgSafety
    extends Terminal<BuchiAcceptance> {
        private final FOperator initialState;
        private final MtBdd<Formula> initialStateSuccessorTree;

        private FgSafety(Factories factories, FOperator formula) {
            super(factories, Set.of(formula), BuchiAcceptance.INSTANCE);
            this.initialState = formula;
            this.initialStateSuccessorTree = this.successorTreeInternal(this.initialState.operand(), Function.identity());
        }

        public static FgSafety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isFgSafety(formula));
            return new FgSafety(factories, (FOperator)formula);
        }

        @Override
        public MtBdd<Edge<Formula>> edgeTreeImpl(Formula state) {
            return this.initialState.equals(state) ? this.initialStateSuccessorTree.map(x -> this.successorToEdge((Set<Formula>)Sets.union((Set)x, this.initialStates()))) : this.successorTreeInternal(state, this::successorToEdge);
        }

        @Override
        protected Edge<Formula> buildEdge(Formula successor) {
            return this.initialState.equals(successor) ? Edge.of(successor) : Edge.of(successor, 0);
        }
    }

    public static final class Tracking
    extends NonLooping<AllAcceptance> {
        public Tracking(Factories factories, Formula formula) {
            super(factories, formula, AllAcceptance.INSTANCE);
        }

        @Override
        Edge<Formula> buildEdge(Formula clause) {
            return Edge.of(clause);
        }
    }

    public static final class Safety
    extends NonLooping<AllAcceptance> {
        private final Formula initialFormula;

        private Safety(Factories factories, Formula formula) {
            super(factories, formula, AllAcceptance.INSTANCE);
            this.initialFormula = formula;
        }

        public static Safety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isSafety(formula));
            return new Safety(factories, formula);
        }

        @Override
        protected Edge<Formula> buildEdge(Formula successor) {
            return Edge.of(successor);
        }

        public Set<Formula> initialStatesWithRemainder(Formula remainder) {
            return Safety.reducedDnf(this.factory.of(Conjunction.of(this.initialFormula, remainder)));
        }
    }

    public static final class CoSafety
    extends NonLooping<BuchiAcceptance> {
        private CoSafety(Factories factories, Formula formula) {
            super(factories, formula, BuchiAcceptance.INSTANCE);
        }

        public static CoSafety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isCoSafety(formula));
            return new CoSafety(factories, formula);
        }

        @Override
        protected Edge<Formula> buildEdge(Formula successor) {
            return BooleanConstant.TRUE.equals(successor) ? Edge.of(successor, 0) : Edge.of(successor);
        }
    }

    private static abstract class NonLooping<A extends EmersonLeiAcceptance>
    extends Terminal<A> {
        private NonLooping(Factories factories, Formula formula, A acceptance) {
            super(factories, NonLooping.reducedDnf(factories.eqFactory.of(formula)), acceptance);
        }

        @Override
        public final MtBdd<Edge<Formula>> edgeTreeImpl(Formula state) {
            return this.successorTreeInternal(state, this::successorToEdge);
        }
    }

    private static abstract class Terminal<A extends EmersonLeiAcceptance>
    extends Base<Formula, A> {
        private Terminal(Factories factories, Set<Formula> initialStates, A acceptance) {
            super(factories, initialStates, acceptance);
        }

        Set<Edge<Formula>> successorToEdge(Set<Formula> successors) {
            return successors.stream().map(this::buildEdge).collect(Collectors.toUnmodifiableSet());
        }

        abstract Edge<Formula> buildEdge(Formula var1);
    }

    static abstract class Base<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<S, A> {
        final EquivalenceClassFactory factory;

        Base(Factories factories, Set<S> initialStates, A acceptance) {
            super(factories.eqFactory.atomicPropositions(), factories.vsFactory, initialStates, acceptance);
            this.factory = factories.eqFactory;
        }

        private static Formula unfoldWithSuspension(Formula formula) {
            return formula.accept(UnfoldWithSuspension.INSTANCE);
        }

        <T> MtBdd<T> successorTreeInternal(Formula state, Function<? super Set<Formula>, ? extends Set<T>> mapper) {
            return Base.successorTreeInternal(state, mapper, this.factory);
        }

        static <T> Set<T> successorsInternal(Formula state, BitSet valuation, Function<? super Set<Formula>, ? extends Set<T>> mapper, EquivalenceClassFactory factory) {
            return mapper.apply(Base.reducedDnf(factory.of(Base.unfoldWithSuspension(state).temporalStep(valuation))));
        }

        static <T> MtBdd<T> successorTreeInternal(Formula state, Function<? super Set<Formula>, ? extends Set<T>> mapper, EquivalenceClassFactory factory) {
            return factory.of(Base.unfoldWithSuspension(state)).temporalStepTree().map(x -> x.stream().flatMap(y -> ((Set)mapper.apply(Base.reducedDnf(y))).stream()).collect(Collectors.toUnmodifiableSet()));
        }

        static Set<Formula> reducedDnf(EquivalenceClass equivalenceClass) {
            EquivalenceClassFactory factory = equivalenceClass.factory();
            if (equivalenceClass.isFalse()) {
                return Set.of();
            }
            if (equivalenceClass.support(false).stream().allMatch(x -> x instanceof Literal || x instanceof XOperator)) {
                return Set.of(equivalenceClass.canonicalRepresentativeDnf());
            }
            HashMap<Set, Set> groupedClauses = new HashMap<Set, Set>();
            for (Set<Formula> clause : equivalenceClass.disjunctiveNormalForm()) {
                Formula simplifiedFormula = SyntacticSimplifier.visitConjunction(clause, false);
                List<Formula> simplifiedClause = simplifiedFormula instanceof Conjunction ? simplifiedFormula.operands : List.of(simplifiedFormula);
                EquivalenceClass simplifiedClauseClazz = factory.of(Conjunction.of(simplifiedClause).unfold());
                if (simplifiedClauseClazz.isTrue()) {
                    return Set.of(BooleanConstant.TRUE);
                }
                if (simplifiedClauseClazz.isFalse()) continue;
                HashSet<Formula> literalOrX2 = new HashSet<Formula>();
                HashSet<Formula> reducedClause2 = new HashSet<Formula>();
                for (Formula formula : simplifiedClause) {
                    if (formula.accept(IsLiteralOrXVisitor.INSTANCE).booleanValue()) {
                        literalOrX2.add(formula);
                        continue;
                    }
                    reducedClause2.add(formula);
                }
                groupedClauses.compute(reducedClause2, (oldKey, oldValue) -> {
                    if (oldValue == null) {
                        HashSet<Set> set = new HashSet<Set>();
                        set.add(literalOrX2);
                        return set;
                    }
                    oldValue.add(literalOrX2);
                    return oldValue;
                });
            }
            HashSet<Formula> clauses = new HashSet<Formula>();
            groupedClauses.forEach((reducedClause, literalOrX) -> {
                Formula literalOrXFormula = Disjunction.of(literalOrX.stream().map(Conjunction::of));
                reducedClause.add(literalOrXFormula);
                clauses.add(Conjunction.of(reducedClause));
            });
            if (clauses.contains(BooleanConstant.TRUE)) {
                return Set.of(BooleanConstant.TRUE);
            }
            clauses.remove(BooleanConstant.FALSE);
            return clauses;
        }

        private static class UnfoldWithSuspension
        extends Converter {
            private static final UnfoldWithSuspension INSTANCE = new UnfoldWithSuspension();

            private UnfoldWithSuspension() {
                super(SyntacticFragment.NNF);
            }

            @Override
            public Formula visit(FOperator fOperator) {
                return fOperator.isSuspendable() ? fOperator : Disjunction.of((Formula)fOperator, fOperator.operand().accept(this));
            }

            @Override
            public Formula visit(GOperator gOperator) {
                return gOperator.isSuspendable() ? gOperator : Conjunction.of((Formula)gOperator, gOperator.operand().accept(this));
            }

            @Override
            public Formula visit(MOperator mOperator) {
                return Conjunction.of(mOperator.rightOperand().accept(this), Disjunction.of(mOperator.leftOperand().accept(this), (Formula)mOperator));
            }

            @Override
            public Formula visit(ROperator rOperator) {
                return Conjunction.of(rOperator.rightOperand().accept(this), Disjunction.of(rOperator.leftOperand().accept(this), (Formula)rOperator));
            }

            @Override
            public Formula visit(UOperator uOperator) {
                return Disjunction.of(uOperator.rightOperand().accept(this), Conjunction.of(uOperator.leftOperand().accept(this), (Formula)uOperator));
            }

            @Override
            public Formula visit(WOperator wOperator) {
                return Disjunction.of(wOperator.rightOperand().accept(this), Conjunction.of(wOperator.leftOperand().accept(this), (Formula)wOperator));
            }

            @Override
            public Formula visit(XOperator xOperator) {
                return xOperator;
            }
        }

        private static final class IsLiteralOrXVisitor
        extends PropositionalVisitor<Boolean> {
            private static final IsLiteralOrXVisitor INSTANCE = new IsLiteralOrXVisitor();

            private IsLiteralOrXVisitor() {
            }

            @Override
            public Boolean visit(BooleanConstant booleanConstant) {
                return true;
            }

            @Override
            public Boolean visit(Conjunction conjunction) {
                return conjunction.operands.stream().allMatch(x -> x.accept(this));
            }

            @Override
            public Boolean visit(Disjunction disjunction) {
                return disjunction.operands.stream().allMatch(x -> x.accept(this));
            }

            @Override
            public Boolean visit(Literal literal) {
                return true;
            }

            @Override
            protected Boolean visit(Formula.TemporalOperator formula) {
                return formula instanceof XOperator;
            }
        }
    }
}

