/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import owl.automaton.AnnotatedState;
import owl.automaton.AnnotatedStateOptimisation;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.optimization.ParityAcceptanceOptimizations;
import owl.ltl.LabelledFormula;
import owl.translations.ltl2dpa.AsymmetricDPAConstruction;
import owl.translations.ltl2dpa.SymmetricDPAConstruction;
import owl.util.ParallelEvaluation;

public class LTL2DPAFunction
implements Function<LabelledFormula, Automaton<?, ParityAcceptance>> {
    private final EnumSet<Configuration> configuration;
    private final AsymmetricDPAConstruction asymmetricDPAConstruction;
    private final SymmetricDPAConstruction symmetricDPAConstruction;

    public LTL2DPAFunction(Set<Configuration> configuration) {
        this.configuration = EnumSet.copyOf(configuration);
        this.asymmetricDPAConstruction = new AsymmetricDPAConstruction();
        this.symmetricDPAConstruction = new SymmetricDPAConstruction();
    }

    @Override
    public Automaton<?, ParityAcceptance> apply(LabelledFormula formula) {
        Supplier<Optional> automatonSupplier;
        Supplier<Optional> supplier = automatonSupplier = this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> Optional.of(this.postProcess(this.symmetricDPAConstruction.of(formula, false))) : () -> Optional.of(this.postProcess(this.asymmetricDPAConstruction.of(formula, false)));
        Supplier<Optional> complementSupplier = this.configuration.contains((Object)Configuration.COMPLEMENT_CONSTRUCTION_EXACT) ? (this.configuration.contains((Object)Configuration.SYMMETRIC) ? () -> Optional.of(BooleanOperations.deterministicComplementOfCompleteAutomaton(this.postProcess(this.symmetricDPAConstruction.of(formula.not(), true)), ParityAcceptance.class)) : () -> Optional.of(BooleanOperations.deterministicComplementOfCompleteAutomaton(this.postProcess(this.asymmetricDPAConstruction.of(formula.not(), true)), ParityAcceptance.class))) : Optional::empty;
        return OmegaAcceptanceCast.cast(ParallelEvaluation.takeSmallest(ParallelEvaluation.evaluate(List.of(automatonSupplier, complementSupplier))), ParityAcceptance.class);
    }

    private <T extends AnnotatedState<?>> Automaton<T, ParityAcceptance> postProcess(Automaton<T, ParityAcceptance> automaton) {
        if (!this.configuration.contains((Object)Configuration.POST_PROCESS)) {
            return automaton;
        }
        return ParityAcceptanceOptimizations.minimizePriorities(AnnotatedStateOptimisation.optimizeInitialState(automaton));
    }

    public static enum Configuration {
        SYMMETRIC,
        COMPLEMENT_CONSTRUCTION_EXACT,
        POST_PROCESS;

    }
}

