/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.HashSet;
import java.util.Map;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.collections.Collections3;
import owl.ltl.GOperator;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MonitorState;

class MonitorAutomaton
extends AbstractMemoizingAutomaton.EdgeMapImplementation<MonitorState, AllAcceptance> {
    private final Automaton<MonitorState, ParityAcceptance> anyAutomaton;
    private final Map<GSet, Automaton<MonitorState, ParityAcceptance>> automata;
    private final GSet base;

    MonitorAutomaton(Automaton<MonitorState, ParityAcceptance> anyAutomaton, Map<GSet, Automaton<MonitorState, ParityAcceptance>> automata) {
        super(anyAutomaton.atomicPropositions(), anyAutomaton.factory(), anyAutomaton.initialStates(), AllAcceptance.INSTANCE);
        this.automata = Map.copyOf(automata);
        HashSet<GOperator> baseBuilder = new HashSet<GOperator>();
        for (GSet relevantSet : this.automata.keySet()) {
            baseBuilder.addAll(relevantSet);
        }
        this.base = new GSet(baseBuilder);
        this.anyAutomaton = anyAutomaton;
    }

    Map<GSet, Automaton<MonitorState, ParityAcceptance>> getAutomata() {
        return this.automata;
    }

    Automaton<MonitorState, ParityAcceptance> getAutomaton(GSet gSet) {
        GSet intersection = this.base.intersection(gSet);
        Automaton<MonitorState, ParityAcceptance> result = this.automata.get(intersection);
        assert (result != null) : String.format("No automaton found for gSet %s with base %s", gSet, this.base);
        return result;
    }

    @Override
    public Map<Edge<MonitorState>, BddSet> edgeMapImpl(MonitorState state) {
        return Collections3.transformMap(this.anyAutomaton.edgeMap(state), Edge::withoutAcceptance);
    }
}

