/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AParentFolderRegular;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.PreprocessorChangeModeReader;
import net.sourceforge.plantuml.preproc.ReadLineNumbered;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.Preprocessor;
import net.sourceforge.plantuml.preproc2.PreprocessorMode;
import net.sourceforge.plantuml.utils.StartUtils;

public final class BlockUmlBuilder
implements DefinitionsContainer {
    private PreprocessorMode mode = PreprocessorMode.V2_NEW_TIM;
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<FileWithSuffix> usedFiles = new HashSet<FileWithSuffix>();
    private final UncommentReadLine reader2;
    private final Defines defines;
    private final ImportedFiles importedFiles;
    private final String charset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader, File newCurrentDir, String desc) throws IOException {
        Closeable includer = null;
        this.defines = defines;
        this.charset = charset;
        try {
            this.reader2 = new UncommentReadLine(new PreprocessorChangeModeReader(ReadLineReader.create(reader, desc), this));
            this.importedFiles = ImportedFiles.createImportedFiles(new AParentFolderRegular(newCurrentDir));
            includer = new Preprocessor(config, this.reader2, charset, defines, this, this.importedFiles);
            this.init((ReadLineNumbered)includer);
        }
        finally {
            if (includer != null) {
                includer.close();
                this.usedFiles = includer.getFilesUsed();
            }
        }
    }

    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader) throws IOException {
        this(config, charset, defines, reader, null, null);
    }

    private void init(ReadLineNumbered includer) throws IOException {
        StringLocated s = null;
        ArrayList<StringLocated> current2 = null;
        boolean paused = false;
        while ((s = includer.readLine()) != null) {
            StringLocated append;
            if (StartUtils.isArobaseStartDiagram(s.getString())) {
                current2 = new ArrayList<StringLocated>();
                paused = false;
            }
            if (StartUtils.isArobasePauseDiagram(s.getString())) {
                paused = true;
                this.reader2.setPaused(true);
            }
            if (StartUtils.isExit(s.getString())) {
                paused = true;
                this.reader2.setPaused(true);
            }
            if (current2 != null && !paused) {
                current2.add(s);
            } else if (paused && (append = StartUtils.getPossibleAppend(s)) != null) {
                current2.add(append);
            }
            if (StartUtils.isArobaseUnpauseDiagram(s.getString())) {
                paused = false;
                this.reader2.setPaused(false);
            }
            if (!StartUtils.isArobaseEndDiagram(s.getString()) || current2 == null) continue;
            if (paused) {
                current2.add(s);
            }
            this.blocks.add(new BlockUml(current2, this.defines.cloneMe(), null, this));
            current2 = null;
            this.reader2.setPaused(false);
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }

    @Override
    public List<String> getDefinition1(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            this.defines.importFrom(block.getLocalDefines());
            return block.getDefinition(false);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getDefinition2(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            return block.getDefinition2(false);
        }
        return Collections.emptyList();
    }

    @Override
    public PreprocessorMode getPreprocessorMode() {
        return this.mode;
    }

    @Override
    public void setPreprocessorMode(PreprocessorMode mode) {
        this.mode = mode;
    }

    @Override
    public final ImportedFiles getImportedFiles() {
        return this.importedFiles;
    }

    @Override
    public final String getCharset() {
        return this.charset;
    }
}

