/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleDefinition;
import net.sourceforge.plantuml.style.WithStyle;

public class Participant
implements SpecificBackcolorable,
WithStyle {
    private final String code;
    private Display display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private boolean stereotypePositionTop;
    private final Set<EntityPortion> hiddenPortions;
    private final int order;
    private final StyleBuilder styleBuilder;
    private Style style;
    private SymbolContext liveBackcolors;
    private Colors colors = Colors.empty();
    private Url url;

    @Override
    public StyleDefinition getDefaultStyleDefinition() {
        return this.type.getDefaultStyleDefinition();
    }

    @Override
    public Style[] getUsedStyles() {
        Style tmp = this.style;
        if (tmp != null) {
            tmp = tmp.eventuallyOverride(this.getColors(null));
        }
        Style stereo = this.getDefaultStyleDefinition().with(this.stereotype).getMergedStyle(this.styleBuilder);
        if (tmp != null) {
            stereo = tmp.mergeWith(stereo);
        }
        return new Style[]{tmp, stereo};
    }

    public Participant(ParticipantType type, String code, Display display, Set<EntityPortion> hiddenPortions, int order, StyleBuilder styleBuilder) {
        this.hiddenPortions = hiddenPortions;
        this.styleBuilder = styleBuilder;
        this.order = order;
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display) || display.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.code = code;
        this.type = type;
        this.display = display;
        if (SkinParam.USE_STYLES()) {
            this.style = this.getDefaultStyleDefinition().getMergedStyle(styleBuilder);
        }
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public Display getDisplay(boolean underlined) {
        Display result;
        Display display = result = underlined ? this.display.underlined() : this.display;
        if (this.stereotype != null && !this.hiddenPortions.contains((Object)EntityPortion.STEREOTYPE)) {
            result = this.stereotypePositionTop ? result.addFirst(this.stereotype) : result.add(this.stereotype);
        }
        return result;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype, boolean stereotypePositionTop) {
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        this.stereotype = stereotype;
        this.stereotypePositionTop = stereotypePositionTop;
        if (SkinParam.USE_STYLES()) {
            for (Style style : stereotype.getStyles(this.styleBuilder)) {
                this.style = this.style.mergeWith(style);
            }
        }
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(SymbolContext colors) {
        ++this.initialLife;
        this.liveBackcolors = colors;
    }

    public SymbolContext getLiveSpecificBackColors() {
        return this.liveBackcolors;
    }

    @Override
    public Colors getColors(ISkinParam skinParam) {
        return this.colors;
    }

    public void setSpecificColorTOBEREMOVED(ColorType type, HtmlColor color) {
        if (color != null) {
            this.colors = this.colors.add(type, color);
        }
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public ColorParam getBackgroundColorParam() {
        return this.type.getBackgroundColorParam();
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam skinParam) {
        HtmlColor specificBackColor = this.getColors(skinParam).getColor(ColorType.BACK);
        boolean clickable = this.getUrl() != null;
        HtmlColor stereoBackColor = skinParam.getHtmlColor(this.getBackgroundColorParam(), this.getStereotype(), clickable);
        if (stereoBackColor != null && specificBackColor == null) {
            specificBackColor = stereoBackColor;
        }
        SkinParamBackcolored result = new SkinParamBackcolored(skinParam, specificBackColor, clickable);
        HtmlColor stereoBorderColor = skinParam.getHtmlColor(ColorParam.participantBorder, this.getStereotype(), clickable);
        if (stereoBorderColor != null) {
            result.forceColor(ColorParam.participantBorder, stereoBorderColor);
        }
        return result;
    }

    public int getOrder() {
        return this.order;
    }
}

