/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.StyleKind;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueColor;
import net.sourceforge.plantuml.style.ValueNull;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Style {
    private final Map<PName, Value> map;
    private final String name;
    private final StyleKind kind;

    public Style(StyleKind kind, String name, Map<PName, Value> map) {
        this.map = map;
        this.name = name;
        this.kind = kind;
    }

    public final StyleKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.name + " " + this.map;
    }

    public Value value(PName name) {
        Value result = this.map.get((Object)name);
        if (result == null) {
            return ValueNull.NULL;
        }
        return result;
    }

    public Style mergeWith(Style other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        EnumMap<PName, Value> both = new EnumMap<PName, Value>(this.map);
        for (Map.Entry<PName, Value> ent : other.map.entrySet()) {
            Value previous = this.map.get((Object)ent.getKey());
            if (previous != null && ent.getValue().getPriority() <= previous.getPriority()) continue;
            both.put((PName)((Enum)ent.getKey()), ent.getValue());
        }
        if (this.name.equals(other.name)) {
            return new Style(this.kind.add(other.kind), this.name, both);
        }
        return new Style(this.kind.add(other.kind), this.name + "," + other.name, both);
    }

    public Style eventuallyOverride(PName param, HtmlColor color) {
        if (color == null) {
            return this;
        }
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(this.map);
        result.put(param, new ValueColor(color));
        return new Style(this.kind, this.name + "-" + color, result);
    }

    public Style eventuallyOverride(Colors colors) {
        Style result = this;
        HtmlColor back = colors.getColor(ColorType.BACK);
        if (back != null) {
            result = this.eventuallyOverride(PName.BackGroundColor, back);
        }
        return result;
    }

    public String getStyleName() {
        return this.name;
    }

    public UFont getUFont() {
        String family = this.value(PName.FontName).asString();
        int fontStyle = this.value(PName.FontStyle).asFontStyle();
        int size = this.value(PName.FontSize).asInt();
        return new UFont(family, fontStyle, size);
    }

    public FontConfiguration getFontConfiguration(IHtmlColorSet set) {
        UFont font = this.getUFont();
        HtmlColor color = this.value(PName.FontColor).asColor(set);
        HtmlColor hyperlinkColor = this.value(PName.HyperLinkColor).asColor(set);
        return new FontConfiguration(font, color, hyperlinkColor, true);
    }

    public SymbolContext getSymbolContext(IHtmlColorSet set) {
        HtmlColor backColor = this.value(PName.BackGroundColor).asColor(set);
        HtmlColor foreColor = this.value(PName.LineColor).asColor(set);
        double deltaShadowing = this.value(PName.Shadowing).asDouble();
        return new SymbolContext(backColor, foreColor).withStroke(this.getStroke()).withDeltaShadow(deltaShadowing);
    }

    public UStroke getStroke() {
        double thickness = this.value(PName.LineThickness).asDouble();
        return new UStroke(thickness);
    }

    private TextBlock createTextBlockInternal(Display display, IHtmlColorSet set, ISkinSimple spriteContainer) {
        FontConfiguration fc = this.getFontConfiguration(set);
        return display.create(fc, HorizontalAlignment.LEFT, spriteContainer);
    }

    public TextBlock createTextBlockBordered(Display note, IHtmlColorSet set, ISkinSimple spriteContainer) {
        TextBlock textBlock = this.createTextBlockInternal(note, set, spriteContainer);
        HtmlColor legendBackgroundColor = this.value(PName.BackGroundColor).asColor(set);
        HtmlColor legendColor = this.value(PName.LineColor).asColor(set);
        UStroke stroke = this.getStroke();
        int cornersize = this.value(PName.RoundCorner).asInt();
        double margin = this.value(PName.Margin).asDouble();
        double padding = this.value(PName.Padding).asDouble();
        TextBlock result = TextBlockUtils.bordered(textBlock, stroke, legendColor, legendBackgroundColor, cornersize, padding, padding);
        return TextBlockUtils.withMargin(result, margin, margin);
    }
}

