/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;

public class StyleDefinition {
    private final List<String> namesStrings = new ArrayList<String>();

    private StyleDefinition(List<String> copy) {
        this.namesStrings.addAll(copy);
    }

    public static StyleDefinition of(SName ... names) {
        ArrayList<String> result = new ArrayList<String>();
        for (SName name : names) {
            result.add(name.name());
        }
        return new StyleDefinition(result);
    }

    public StyleDefinition with(Stereotype stereotype) {
        ArrayList<String> result = new ArrayList<String>(this.namesStrings);
        if (stereotype != null) {
            for (String name : stereotype.getStyleNames()) {
                result.add(name);
            }
        }
        result.add(SName.stereotype.name());
        return new StyleDefinition(result);
    }

    public StyleDefinition mergeWith(List<Style> others) {
        ArrayList<String> copy = new ArrayList<String>(this.namesStrings);
        for (Style other : others) {
            copy.add(other.getStyleName());
        }
        return new StyleDefinition(copy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.namesStrings) {
            sb.append(name);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public Style getMergedStyle(StyleBuilder styleBuilder) {
        if (styleBuilder == null) {
            return null;
        }
        return styleBuilder.getMergedStyle(this.namesStrings);
    }
}

