/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;

public class Trie {
    private final Map<Character, Trie> brothers = new HashMap<Character, Trie>();

    public void add(String s) {
        if (s.indexOf(0) != -1) {
            throw new IllegalArgumentException();
        }
        Trie.addInternal(this, s + "\u0000");
    }

    private static void addInternal(Trie current, String s) {
        if (s.length() == 0) {
            throw new UnsupportedOperationException();
        }
        while (s.length() > 0) {
            Character added = Character.valueOf(s.charAt(0));
            Trie child = current.getOrCreate(added);
            s = s.substring(1);
            current = child;
        }
    }

    public boolean remove(String s) {
        return Trie.removeInternal(this, s + "\u0000");
    }

    private static boolean removeInternal(Trie current, String s) {
        if (s.length() <= 1) {
            throw new UnsupportedOperationException();
        }
        while (s.length() > 0) {
            Character first = Character.valueOf(s.charAt(0));
            Trie child = current.brothers.get(first);
            if (child == null) {
                return false;
            }
            if ((s = s.substring(1)).length() == 1) {
                assert (s.charAt(0) == '\u0000');
                return child.brothers.remove(Character.valueOf('\u0000')) != null;
            }
            current = child;
        }
        throw new IllegalStateException();
    }

    private Trie getOrCreate(Character added) {
        Trie result = this.brothers.get(added);
        if (result == null) {
            result = new Trie();
            this.brothers.put(added, result);
        }
        return result;
    }

    public String getLonguestMatchStartingIn(String s) {
        return Trie.getLonguestMatchStartingIn(this, s);
    }

    private static String getLonguestMatchStartingIn(Trie current, String s) {
        StringBuilder result = new StringBuilder();
        while (current != null) {
            if (s.length() == 0) {
                if (current.brothers.containsKey(Character.valueOf('\u0000'))) {
                    return result.toString();
                }
                return "";
            }
            Trie child = current.brothers.get(Character.valueOf(s.charAt(0)));
            if (child == null || child.brothers.size() == 0) {
                if (current.brothers.containsKey(Character.valueOf('\u0000'))) {
                    return result.toString();
                }
                return "";
            }
            result.append(s.charAt(0));
            current = child;
            s = s.substring(1);
        }
        return "";
    }
}

